/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

public class NoEmptyLineSeparatorCheck
extends AbstractCheck {
    private static final String MSG_LINE_AFTER_OPENING_BRACE_EMPTY = "Remove empty line after opening brace";
    private static final String MSG_LINE_BEFORE_CLOSING_BRACE_EMPTY = "Remove empty line before closing brace";
    private static final String MSG_FOR_EMPTY_LINE = "Remove empty line";
    private boolean isCaseGroupWithoutBraces = false;
    private boolean isCaseGroupWithoutListOfStatements = false;
    private boolean isCaseGroupWithBraces = false;

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{12, 11, 9, 8, 84, 85, 95, 96, 97, 83, 92, 67, 89, 93, 94, 33};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        DetailAST leftCurly = this.findLeftCurly(ast);
        DetailAST rightCurly = this.findRightCurly(ast);
        if (leftCurly != null && rightCurly != null) {
            boolean isLineBeforeClosingBraceEmpty;
            int rightCurlyLine;
            int leftCurlyLine = leftCurly.getLineNo();
            if (leftCurlyLine == (rightCurlyLine = rightCurly.getLineNo())) {
                return;
            }
            int lineAfterLeftCurly = leftCurlyLine + 1;
            int lineBeforeRightCurly = rightCurlyLine - 1;
            if (this.isBlank(lineAfterLeftCurly)) {
                if (this.isCaseGroupWithoutBraces) {
                    boolean isEmptyLineWithWarningForCaseGroup;
                    boolean isLineAfterOpeningBrace = lineAfterLeftCurly == lineBeforeRightCurly;
                    boolean bl = isEmptyLineWithWarningForCaseGroup = !isLineAfterOpeningBrace || !this.isCaseGroupWithBraces && !this.isCaseGroupWithoutListOfStatements;
                    if (isEmptyLineWithWarningForCaseGroup) {
                        this.log(lineAfterLeftCurly, MSG_FOR_EMPTY_LINE, new Object[0]);
                    }
                } else {
                    this.log(lineAfterLeftCurly, MSG_LINE_AFTER_OPENING_BRACE_EMPTY, new Object[0]);
                }
            }
            boolean isLineBeforeClosingBrace = lineAfterLeftCurly < lineBeforeRightCurly;
            boolean bl = isLineBeforeClosingBraceEmpty = this.isBlank(lineBeforeRightCurly) && isLineBeforeClosingBrace && !this.isCaseGroupWithoutBraces;
            if (isLineBeforeClosingBraceEmpty) {
                this.log(lineBeforeRightCurly, MSG_LINE_BEFORE_CLOSING_BRACE_EMPTY, new Object[0]);
            }
        }
    }

    private DetailAST findLeftCurly(DetailAST ast) {
        switch (ast.getType()) {
            case 93: 
            case 94: {
                if (ast.getParent().getType() == 161) {
                    return null;
                }
                DetailAST nextNode = ast.getParent().getNextSibling();
                return nextNode != null ? ast : null;
            }
        }
        return this.findLeftCurlyInBlock(ast);
    }

    private DetailAST findRightCurly(DetailAST ast) {
        switch (ast.getType()) {
            case 93: 
            case 94: {
                if (ast.getParent().getType() == 161) {
                    return null;
                }
                DetailAST nextNode = ast.getParent().getNextSibling();
                if (nextNode != null) {
                    DetailAST nextCaseClause = nextNode.getFirstChild();
                    DetailAST nextSlist = ast.getNextSibling();
                    DetailAST getNextSlist = nextSlist != null ? nextSlist : nextNode;
                    DetailAST getNextCaseClause = nextCaseClause != null ? nextCaseClause : getNextSlist;
                    return getNextCaseClause;
                }
            }
            case 33: {
                DetailAST slistAST = ast.findFirstToken(7);
                if (slistAST != null) {
                    this.isCaseGroupWithoutBraces = slistAST.getFirstChild().getType() != 7;
                    this.isCaseGroupWithBraces = ast.getLineNo() == slistAST.getFirstChild().getLineNo();
                    return this.findRightCurlyInBlock(slistAST);
                }
                this.isCaseGroupWithoutListOfStatements = true;
                return this.findRightCurlyInBlock(ast);
            }
        }
        return this.findRightCurlyInBlock(ast);
    }

    private DetailAST findLeftCurlyInBlock(DetailAST ast) {
        DetailAST slistAST = ast.findFirstToken(7);
        DetailAST leftCurly = slistAST == null ? ast.findFirstToken(72) : slistAST;
        return leftCurly;
    }

    private DetailAST findRightCurlyInBlock(DetailAST ast) {
        DetailAST slistAST = ast.findFirstToken(7);
        DetailAST rightCurly = slistAST == null ? ast.findFirstToken(73) : slistAST.getLastChild();
        return rightCurly;
    }

    private boolean isBlank(int lineNumber) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("Line numbering starts from 1");
        }
        return this.getFileContents().lineIsBlank(lineNumber - 1);
    }
}

