/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.tools.analysis.utils.SatCheckUtils;

public class NullAnnotationsCheck
extends AbstractCheck {
    private List<String> imports = new ArrayList<String>();
    private static final String NONNULL_ANNOTATION = NonNull.class.getSimpleName();
    private static final String NULLABLE_ANNOTATION = Nullable.class.getSimpleName();
    private static final String NONNULLBYDEFAULT_ANNOTATION = NonNullByDefault.class.getSimpleName();
    private static final String WARNING_MESSAGE_MISSING_ANNOTATION = String.format("Classes/Interfaces should be annotated with @%s", NONNULLBYDEFAULT_ANNOTATION);
    private static final String WARNING_MESSAGE_NONNULL_ANNOTATION = String.format("There is no need for a @%s annotation because it is set as default. Only @%s should be used", NONNULL_ANNOTATION, NULLABLE_ANNOTATION);
    private boolean checkInnerUnits;

    public void setCheckInnerUnits(boolean checkInnerUnits) {
        this.checkInnerUnits = checkInnerUnits;
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{30, 170, 14, 15};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        int tokenType = ast.getType();
        switch (tokenType) {
            case 30: {
                String packageImport = CheckUtil.createFullType((DetailAST)ast).getText();
                this.imports.add(packageImport);
                break;
            }
            case 14: {
                this.visit(ast);
                break;
            }
            case 15: {
                this.visit(ast);
                break;
            }
            case 170: {
                this.checkForNonNullAnnotation(ast);
            }
        }
    }

    private void visit(DetailAST ast) {
        if (!this.checkInnerUnits) {
            DetailAST astParent = ast.getParent();
            if (astParent == null) {
                this.checkForNonNullByDefaultAnnotation(ast);
            }
        } else {
            this.checkForNonNullByDefaultAnnotation(ast);
        }
    }

    private void checkForNonNullByDefaultAnnotation(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        int numberOfAnnotations = modifiers.getChildCount(159);
        int lineNo = modifiers.getLineNo();
        if (numberOfAnnotations == 0) {
            this.log(lineNo, WARNING_MESSAGE_MISSING_ANNOTATION, new Object[0]);
        } else if (!this.isAnnotationPresent(modifiers)) {
            this.log(lineNo + numberOfAnnotations, WARNING_MESSAGE_MISSING_ANNOTATION, new Object[0]);
        }
    }

    private boolean isAnnotationPresent(DetailAST ast) {
        List<DetailAST> annotations = SatCheckUtils.getAllChildrenNodesOfType(ast, 159);
        for (DetailAST annotationAST : annotations) {
            String annotationName = annotationAST.getFirstChild().getNextSibling().getText();
            if (!NONNULLBYDEFAULT_ANNOTATION.equals(annotationName) || !this.imports.contains(NonNullByDefault.class.getName())) continue;
            return true;
        }
        return false;
    }

    private void checkForNonNullAnnotation(DetailAST ast) {
        DetailAST atClause = CheckUtil.getFirstNode((DetailAST)ast);
        String annotationName = atClause.getNextSibling().getText();
        if (NONNULL_ANNOTATION.equals(annotationName) && this.imports.contains(NonNull.class.getName())) {
            this.log(atClause.getLineNo(), WARNING_MESSAGE_NONNULL_ANNOTATION, new Object[0]);
        }
    }
}

