/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class OverridingParentPomConfigurationCheck
extends AbstractStaticCheck {
    private static final String POM_CONFIGURATION_EXPRESSION = "/project//*[@combine.self='override']/@combine.self";
    private final Log logger = LogFactory.getLog(OverridingParentPomConfigurationCheck.class);

    public OverridingParentPomConfigurationCheck() {
        this.setFileExtensions(new String[]{"xml"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (file.getName().equals("pom.xml")) {
            if (this.isEmpty(fileText)) {
                this.log(0, "The pom.xml file should not be empty.", new Object[0]);
            } else {
                Document document = this.parseDomDocumentFromFile(fileText);
                XPathExpression xpathExpression = this.compileXPathExpression(POM_CONFIGURATION_EXPRESSION);
                NodeList nodes = null;
                try {
                    nodes = (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    this.logger.error((Object)"An error has occured while parsing the pom.xml. Check if the file is valid.", (Throwable)e);
                }
                if (nodes != null) {
                    int lineNumber = 0;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        String nodeValue = nodes.item(i).getNodeValue();
                        lineNumber = this.findLineNumberSafe(fileText, nodeValue, lineNumber, "XML node line number not found.");
                        this.log(lineNumber, "Avoid overriding a configuration inherited by the parent pom.", new Object[0]);
                    }
                }
            }
        }
    }
}

