/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ivy.osgi.core.BundleInfo;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class PackageExportsNameCheck
extends AbstractStaticCheck {
    private static final String CORRECT_NAMING_OF_NOT_EXPORTED_PACKAGES_MESSAGE = "The package %s should be marked as \"internal\" if it is not exported.";
    private static final String PACKAGE_PATTERN = "[a-zA-Z0-9\\._-]*";
    private final Log logger = LogFactory.getLog(PackageExportsNameCheck.class);
    private String[] sourceDirectories;
    private String[] excludedPackages;

    public void setSourceDirectories(String[] sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    public void setExcludedPackages(String[] excludePackages) {
        this.excludedPackages = excludePackages;
    }

    public PackageExportsNameCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    protected void processFiltered(File manifestFile, FileText fileText) throws CheckstyleException {
        BundleInfo bundleInfo = this.parseManifestFromFile(fileText);
        Set uniqueManifestExports = bundleInfo.getExports().stream().map(export -> export.getName()).collect(Collectors.toSet());
        File projectDirectory = manifestFile.getParentFile().getParentFile();
        Path projectDirectoryPath = projectDirectory.toPath();
        HashSet<String> sourcePackages = new HashSet<String>();
        try {
            for (String sourcePath : this.sourceDirectories) {
                Path relativeSourcePath = Paths.get(sourcePath, new String[0]);
                Path sourceDirectoryPath = projectDirectoryPath.resolve(relativeSourcePath);
                sourcePackages.addAll(this.getFilteredPackagesFromSourceDirectory(sourceDirectoryPath));
            }
            sourcePackages.removeAll(uniqueManifestExports);
            for (String packageName : sourcePackages) {
                this.log(0, String.format(CORRECT_NAMING_OF_NOT_EXPORTED_PACKAGES_MESSAGE, packageName), new Object[0]);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Problem occurred while processing directories. The check will exit without logging any warnings!", (Throwable)e);
        }
    }

    private Set<String> getFilteredPackagesFromSourceDirectory(final Path sourcePath) throws IOException {
        final HashSet<String> packages = new HashSet<String>();
        if (Files.exists(sourcePath, LinkOption.NOFOLLOW_LINKS)) {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    Path packageRelativePath = sourcePath.relativize(path.getParent());
                    String packageName = packageRelativePath.toString().replaceAll(Matcher.quoteReplacement(File.separator), ".");
                    if (!PackageExportsNameCheck.this.isExcluded(packageName)) {
                        packages.add(packageName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return packages;
    }

    private boolean isExcluded(String packageName) {
        for (String excludePackageName : this.excludedPackages) {
            Pattern pattern = Pattern.compile(excludePackageName = excludePackageName.replaceAll("\\.\\*", PACKAGE_PATTERN));
            Matcher matcher = pattern.matcher(packageName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

