/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ParameterizedRegexpHeaderCheck
extends AbstractHeaderCheck {
    public static final String DEFAULT_JAVADOC_START_COMMENT = "/**";
    public static final String DEFAULT_XML_START_COMMENT = "<!--";
    private static final String SEPARATOR = "\n";
    private static final String MSG_MISMATCH = "Header line doesn''t match pattern {0}";
    private static final String MSG_MISSING = "Header is missing";
    private String[] values;
    private String headerFormat;
    private final List<Pattern> headerRegexps = new ArrayList<Pattern>();

    public void setHeaderFormat(String headerFormat) {
        this.headerFormat = headerFormat;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    protected void postProcessHeaderLines() {
        List headerLines = this.getHeaderLines();
        String header = headerLines.stream().collect(Collectors.joining(SEPARATOR));
        String formattedHeader = MessageFormat.format(header, this.values);
        for (String line : formattedHeader.split(SEPARATOR)) {
            try {
                this.headerRegexps.add(Pattern.compile(line));
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("line " + (this.headerRegexps.size() + 1) + " in header specification is not a regular expression", ex);
            }
        }
    }

    protected void processFiltered(File file, FileText fileText) {
        List referenceHeaderLines;
        if (this.headerFormat == null) {
            this.headerFormat = this.getDefaultHeaderFormat(file);
        }
        if ((referenceHeaderLines = this.getHeaderLines()).size() > fileText.size()) {
            this.log(1, MSG_MISSING, new Object[0]);
        } else {
            if (!this.isComment(this.headerFormat, fileText.get(0))) {
                this.log(1, MSG_MISSING, new Object[0]);
                return;
            }
            for (int i = 0; i < referenceHeaderLines.size(); ++i) {
                if (this.isMatch(fileText.get(i), i)) continue;
                this.log(i + 1, MSG_MISMATCH, new Object[]{this.headerRegexps.get(i).pattern()});
                break;
            }
        }
    }

    private String getDefaultHeaderFormat(File file) {
        switch (FilenameUtils.getExtension((String)file.getName())) {
            case "java": {
                return DEFAULT_JAVADOC_START_COMMENT;
            }
            case "xml": {
                return DEFAULT_XML_START_COMMENT;
            }
        }
        return "";
    }

    private boolean isMatch(String line, int headerLineNo) {
        return this.headerRegexps.get(headerLineNo).matcher(line).find();
    }

    private boolean isComment(String type, String line) {
        return line.trim().startsWith(type.trim());
    }
}

