/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.openhab.tools.analysis.utils.ContentReceviedCallback;

public class CachingHttpClient<T> {
    private static final int RETRY_TIME = 10;
    private static Cache<URL, Optional<byte[]>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private ContentReceviedCallback<T> callback;

    public CachingHttpClient(ContentReceviedCallback<T> callback) {
        this.callback = callback;
    }

    public synchronized T get(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        Optional content = Optional.empty();
        try {
            content = (Optional)cache.get((Object)url, () -> Optional.of(this.getContent(url)));
        }
        catch (ExecutionException e) {
            cache.put((Object)url, Optional.empty());
            throw new IOException("Unable to get " + url.toString(), e.getCause());
        }
        return content.isPresent() ? (T)this.callback.transform((byte[])content.get()) : null;
    }

    private byte[] getContent(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try (InputStream input = connection.getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)input, (OutputStream)output);
                byArray = output.toByteArray();
            }
            return byArray;
        }
    }
}

