/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.ByteNearestNeighboursProvider;
import org.openimaj.knn.pq.ByteProductQuantiser;
import org.openimaj.ml.clustering.kmeans.ByteKMeans;

public final class ByteProductQuantiserUtilities {
    private ByteProductQuantiserUtilities() {
    }

    public static ByteProductQuantiser train(byte[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        byte[][] tmp = new byte[data.length][subDim];
        ByteNearestNeighbours[] assigners = new ByteNearestNeighbours[numAssigners];
        ByteKMeans kmeans = ByteKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            ByteNearestNeighboursProvider centroids = (ByteNearestNeighboursProvider)kmeans.cluster(tmp);
            assigners[i] = centroids.getNearestNeighbours();
        }
        return new ByteProductQuantiser(assigners);
    }

    public static ByteProductQuantiser train(byte[][] data, int numAssigners, int nIter) {
        return ByteProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

