/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.FloatNearestNeighbours;
import org.openimaj.knn.FloatNearestNeighboursProvider;
import org.openimaj.knn.pq.FloatProductQuantiser;
import org.openimaj.ml.clustering.kmeans.FloatKMeans;

public final class FloatProductQuantiserUtilities {
    private FloatProductQuantiserUtilities() {
    }

    public static FloatProductQuantiser train(float[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        float[][] tmp = new float[data.length][subDim];
        FloatNearestNeighbours[] assigners = new FloatNearestNeighbours[numAssigners];
        FloatKMeans kmeans = FloatKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            FloatNearestNeighboursProvider centroids = (FloatNearestNeighboursProvider)kmeans.cluster(tmp);
            assigners[i] = centroids.getNearestNeighbours();
        }
        return new FloatProductQuantiser(assigners);
    }

    public static FloatProductQuantiser train(float[][] data, int numAssigners, int nIter) {
        return FloatProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

