/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering;

import gnu.trove.list.array.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.ml.clustering.Clusters;

public class IndexClusters
implements Clusters {
    protected int[][] clusters;
    protected int nEntries;

    public IndexClusters() {
    }

    public IndexClusters(int[][] clusters, int nEntries) {
        this.nEntries = nEntries;
        this.clusters = clusters;
    }

    public IndexClusters(int[][] clusters) {
        this.nEntries = 0;
        this.clusters = clusters;
        for (int i = 0; i < clusters.length; ++i) {
            this.nEntries += clusters[i].length;
        }
    }

    public IndexClusters(int[] assignments) {
        this.nEntries = assignments.length;
        HashMap<Integer, TIntArrayList> clusters = new HashMap<Integer, TIntArrayList>();
        for (int i = 0; i < assignments.length; ++i) {
            int ass = assignments[i];
            TIntArrayList current = (TIntArrayList)clusters.get(ass);
            if (current == null) {
                current = new TIntArrayList();
                clusters.put(ass, current);
            }
            current.add(i);
        }
        int clustersSeen = 0;
        this.clusters = new int[clusters.size()][];
        for (Map.Entry i : clusters.entrySet()) {
            this.clusters[clustersSeen] = ((TIntArrayList)i.getValue()).toArray();
            ++clustersSeen;
        }
    }

    public IndexClusters(List<int[]> completedClusters) {
        this.nEntries = 0;
        this.clusters = new int[completedClusters.size()][];
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = completedClusters.get(i);
            this.nEntries += this.clusters[i].length;
        }
    }

    public int[][] clusters() {
        return this.clusters;
    }

    public int numEntries() {
        return this.nEntries;
    }

    public int numClusters() {
        return this.clusters.length;
    }

    public void readASCII(Scanner in) throws IOException {
        this.clusters = new int[in.nextInt()][];
        this.nEntries = in.nextInt();
        int i = 0;
        while (i < this.nEntries) {
            int cluster = in.nextInt();
            int count = in.nextInt();
            i += count;
            this.clusters[cluster] = new int[count];
            for (int j = 0; j < count; ++j) {
                this.clusters[cluster][j] = in.nextInt();
            }
        }
    }

    public String asciiHeader() {
        return "IDXCLST";
    }

    public void readBinary(DataInput in) throws IOException {
        this.clusters = new int[in.readInt()][];
        this.nEntries = in.readInt();
        int i = 0;
        while (i < this.nEntries) {
            int cluster = in.readInt();
            int count = in.readInt();
            i += count;
            this.clusters[cluster] = new int[count];
            for (int j = 0; j < count; ++j) {
                this.clusters[cluster][j] = in.readInt();
            }
        }
    }

    public byte[] binaryHeader() {
        return this.asciiHeader().getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(this.numClusters());
        out.println(this.nEntries);
        for (int i = 0; i < this.clusters.length; ++i) {
            int[] cluster = this.clusters[i];
            out.println(i);
            out.println(cluster.length);
            for (int j = 0; j < cluster.length; ++j) {
                out.println(cluster[j]);
            }
        }
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.numClusters());
        out.writeInt(this.nEntries);
        for (int i = 0; i < this.clusters.length; ++i) {
            int[] cluster = this.clusters[i];
            out.writeInt(i);
            out.writeInt(cluster.length);
            for (int j = 0; j < cluster.length; ++j) {
                out.writeInt(cluster[j]);
            }
        }
    }

    public String toString() {
        int[][] clusters = this.clusters();
        int i = 0;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("N-Clusters: " + this.numClusters());
        out.println("Entities: " + this.numEntries());
        String str = sw.toString();
        for (int[] member : clusters) {
            str = str + String.format("%d %s\n", i++, Arrays.toString(member));
        }
        return str;
    }
}

