/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.soft.HierarchicalIntPathAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalIntKMeansResult;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.IntFloatPair;

public class HierarchicalIntHardAssigner
implements HardAssigner<int[], float[], IntFloatPair> {
    protected HierarchicalIntKMeansResult result;
    protected HierarchicalIntPathAssigner path;
    protected ScoringScheme scorer;

    public HierarchicalIntHardAssigner(HierarchicalIntKMeansResult result, ScoringScheme scorer) {
        this.result = result;
        this.scorer = scorer;
        this.path = new HierarchicalIntPathAssigner(result);
    }

    public HierarchicalIntHardAssigner(HierarchicalIntKMeansResult result) {
        this(result, ScoringScheme.SUM);
    }

    public int[] assign(int[][] data) {
        int[] asgn = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            asgn[i] = this.result.getIndex(this.path.assign(data[i]));
        }
        return asgn;
    }

    @Override
    public int assign(int[] data) {
        return this.result.getIndex(this.path.assign(data));
    }

    public void assignDistance(int[][] data, int[] indices, float[] distances) {
        int depth = this.result.getDepth();
        int[][] d = new int[1][];
        int[][] p = new int[1][depth];
        float[][] w = new float[1][depth];
        for (int i = 0; i < data.length; ++i) {
            d[0] = data[i];
            this.path.assignWeighted(d, p, w);
            indices[i] = this.result.getIndex(p[0]);
            distances[i] = this.scorer.computeScore(w[0]);
        }
    }

    @Override
    public IntFloatPair assignDistance(int[] data) {
        IndependentPair<int[], float[]> pw = this.path.assignWeighted(data);
        int index = this.result.getIndex((int[])pw.firstObject());
        float score = this.scorer.computeScore((float[])pw.secondObject());
        return new IntFloatPair(index, score);
    }

    @Override
    public int size() {
        return this.result.countLeafs();
    }

    @Override
    public int numDimensions() {
        return this.result.numDimensions();
    }

    public static enum ScoringScheme {
        SUM{

            @Override
            public float computeScore(float[] weights) {
                float sum = 0.0f;
                for (float w : weights) {
                    if (w < 0.0f) break;
                    sum += w;
                }
                return sum;
            }
        }
        ,
        PRODUCT{

            @Override
            public float computeScore(float[] weights) {
                float prod = 1.0f;
                for (float w : weights) {
                    if (w < 0.0f) break;
                    prod *= w;
                }
                return prod;
            }
        }
        ,
        FIRST{

            @Override
            public float computeScore(float[] weights) {
                return weights[0];
            }
        }
        ,
        LAST{

            @Override
            public float computeScore(float[] weights) {
                float last = -1.0f;
                for (float w : weights) {
                    if (w < 0.0f) break;
                    last = w;
                }
                return last;
            }
        }
        ,
        MEAN{

            @Override
            public float computeScore(float[] weights) {
                float sum = 0.0f;
                int count = 0;
                for (float w : weights) {
                    if (w < 0.0f) break;
                    sum += w;
                    ++count;
                }
                return sum / (float)count;
            }
        };


        protected abstract float computeScore(float[] var1);
    }
}

