/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.ShortNearestNeighbours;
import org.openimaj.knn.ShortNearestNeighboursProvider;
import org.openimaj.knn.approximate.ShortNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class KDTreeShortEuclideanAssigner
implements HardAssigner<short[], float[], IntFloatPair> {
    protected ShortNearestNeighboursKDTree nn;

    public KDTreeShortEuclideanAssigner(CentroidsProvider<short[]> provider) {
        ShortNearestNeighbours internal;
        if (provider instanceof ShortNearestNeighboursProvider && (internal = ((ShortNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof ShortNearestNeighboursKDTree) {
            this.nn = (ShortNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new ShortNearestNeighboursKDTree((short[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeShortEuclideanAssigner(short[][] data) {
        this.nn = new ShortNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(short[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(short[] data) {
        return this.assign(new short[][]{data})[0];
    }

    public void assignDistance(short[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(short[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((short[][])new short[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

