/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.dbscan;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import org.openimaj.ml.clustering.dbscan.DoubleDBSCANClusters;
import org.openimaj.ml.clustering.dbscan.neighbourhood.RegionMode;
import org.openimaj.util.pair.IntDoublePair;

public class DBSCAN {
    protected boolean noiseAsClusters = false;

    DoubleDBSCANClusters dbscan(final State state) {
        final int[] clusterIndex = new int[]{0};
        for (int p = 0; p < state.length; ++p) {
            if (state.visited.contains(p)) continue;
            state.visited.add(p);
            List<IntDoublePair> region = state.regionMode.regionQuery(p);
            if (!state.regionMode.validRegion(region)) {
                state.noise.add(p);
                continue;
            }
            TIntArrayList cluster = new TIntArrayList();
            state.clusters.put(clusterIndex[0], (Object)cluster);
            this.expandCluster(p, region, (TIntList)cluster, state);
            clusterIndex[0] = clusterIndex[0] + 1;
        }
        if (state.noiseAsClusters) {
            state.noise.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    TIntArrayList arr = new TIntArrayList();
                    arr.add(value);
                    int n = clusterIndex[0];
                    clusterIndex[0] = n + 1;
                    state.clusters.put(n, (Object)arr);
                    return true;
                }
            });
        }
        final int[][] clusterMembers = new int[state.clusters.size()][];
        final int[] nEntries = new int[1];
        state.clusters.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntList>(){

            public boolean execute(int cluster, TIntList b) {
                clusterMembers[cluster] = b.toArray();
                nEntries[0] = nEntries[0] + clusterMembers[cluster].length;
                return true;
            }
        });
        int[] noise = state.noise.toArray();
        DoubleDBSCANClusters dbscanClusters = new DoubleDBSCANClusters(noise, clusterMembers);
        return dbscanClusters;
    }

    private void expandCluster(int p, List<IntDoublePair> region, TIntList cluster, State state) {
        this.addToCluster(p, cluster, state);
        for (int regionIndex = 0; regionIndex < region.size(); ++regionIndex) {
            int pprime = region.get((int)regionIndex).first;
            if (!state.visited.contains(pprime)) {
                state.visited.add(pprime);
                List regionPrime = state.regionMode.regionQuery(pprime);
                if (state.regionMode.validRegion(regionPrime)) {
                    region.addAll(regionPrime);
                } else {
                    state.noise.add(pprime);
                }
            }
            this.addToCluster(pprime, cluster, state);
        }
    }

    private void addToCluster(int p, TIntList cluster, State state) {
        if (!state.addedToCluster.contains(p)) {
            state.noise.remove(p);
            cluster.add(p);
            state.addedToCluster.add(p);
        }
    }

    public void setNoiseAsClusters(boolean b) {
        this.noiseAsClusters = b;
    }

    public static class State {
        TIntHashSet visited = new TIntHashSet();
        TIntHashSet noise = new TIntHashSet();
        TIntHashSet addedToCluster = new TIntHashSet();
        TIntObjectHashMap<TIntList> clusters = new TIntObjectHashMap();
        private RegionMode<IntDoublePair> regionMode;
        private int length;
        private boolean noiseAsClusters;

        public State(int length, RegionMode<IntDoublePair> regionMode) {
            this(length, regionMode, false);
        }

        public State(int length, RegionMode<IntDoublePair> regionMode, boolean noiseAsClusters) {
            this.regionMode = regionMode;
            this.length = length;
            this.noiseAsClusters = noiseAsClusters;
        }
    }
}

