/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactDoubleAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class SphericalKMeansResult
implements SpatialClusters<double[]>,
CentroidsProvider<double[]> {
    static final String HEADER = "CLSTSpKM";
    public double[][] centroids;
    public int[] assignments;

    public boolean equals(Object obj) {
        if (!(obj instanceof SphericalKMeansResult)) {
            return false;
        }
        SphericalKMeansResult other = (SphericalKMeansResult)obj;
        for (int i = 0; i < this.centroids.length; ++i) {
            if (Arrays.equals(this.centroids[i], other.centroids[i])) continue;
            return false;
        }
        return true;
    }

    public String asciiHeader() {
        return "ASCIICLSTSpKM";
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner br) throws IOException {
        int K = Integer.parseInt(br.nextLine().trim());
        int M = Integer.parseInt(br.nextLine().trim());
        this.centroids = new double[K][M];
        for (int k = 0; k < K; ++k) {
            String[] parts = br.nextLine().split(",");
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = Double.parseDouble(parts[d]);
            }
        }
        int A = Integer.parseInt(br.nextLine().trim());
        this.assignments = new int[A];
        for (int a = 0; a < A; ++a) {
            this.assignments[a] = Integer.parseInt(br.nextLine().trim());
        }
    }

    public void readBinary(DataInput in) throws IOException {
        int K = in.readInt();
        int M = in.readInt();
        this.centroids = new double[K][M];
        for (int k = 0; k < K; ++k) {
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = in.readDouble();
            }
        }
        int A = in.readInt();
        this.assignments = new int[A];
        for (int a = 0; a < A; ++a) {
            this.assignments[a] = in.readInt();
        }
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        writer.println(this.centroids.length);
        writer.println(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                writer.print(this.centroids[k][d] + ",");
            }
            writer.println();
        }
        writer.println(this.assignments.length);
        for (int a = 0; a < this.assignments.length; ++a) {
            writer.println(this.assignments[a]);
        }
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.centroids.length);
        out.writeInt(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                out.writeDouble(this.centroids[k][d]);
            }
        }
        out.writeInt(this.assignments.length);
        for (int a = 0; a < this.assignments.length; ++a) {
            out.writeInt(this.assignments[a]);
        }
    }

    public String toString() {
        String str = "";
        str = str + "DoubleCentroidsResult\n";
        str = str + "No. of Clusters: " + this.centroids.length + "\n";
        str = str + "No. of Dimensions: " + this.centroids[0].length + "\n";
        return str;
    }

    public double[][] getCentroids() {
        return this.centroids;
    }

    @Override
    public HardAssigner<double[], double[], IntDoublePair> defaultHardAssigner() {
        return new ExactDoubleAssigner(this, (DoubleFVComparator)DoubleFVComparison.INNER_PRODUCT);
    }

    @Override
    public int numDimensions() {
        return this.centroids[0].length;
    }

    @Override
    public int numClusters() {
        return this.centroids.length;
    }

    public int[] getAssignmentHistogram() {
        int[] hist = new int[this.centroids.length];
        for (int i = 0; i < this.assignments.length; ++i) {
            int n = this.assignments[i];
            hist[n] = hist[n] + 1;
        }
        return hist;
    }

    public double[][] filter(int threshold) {
        int[] hist = this.getAssignmentHistogram();
        TIntArrayList toKeep = new TIntArrayList();
        for (int i = 0; i < hist.length; ++i) {
            if (hist[i] <= threshold) continue;
            toKeep.add(i);
        }
        final double[][] fcen = new double[toKeep.size()][];
        toKeep.forEach(new TIntProcedure(){
            int i = 0;

            public boolean execute(int value) {
                fcen[this.i++] = SphericalKMeansResult.this.centroids[value];
                return true;
            }
        });
        return fcen;
    }
}

