/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.rac;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BisectionSolver;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

@Reference(type=ReferenceType.Inproceedings, author={"Amirthalingam Ramanan", "Mahesan Niranjan"}, title="Resource-Allocating Codebook for Patch-based Face Recognition", year="2009", booktitle="IIS", url="http://eprints.ecs.soton.ac.uk/21401/")
public class IntRAC
implements SpatialClusters<int[]>,
SpatialClusterer<IntRAC, int[]>,
CentroidsProvider<int[]>,
HardAssigner<int[], float[], IntFloatPair> {
    private static final String HEADER = "CLSTRAIC";
    protected ArrayList<int[]> codebook = new ArrayList();
    protected double threshold = 128.0;
    protected int nDims = -1;
    protected static int[][] distances;
    protected long totalSamples = 0L;

    public IntRAC() {
    }

    public IntRAC(double radiusSquared) {
        this();
        this.threshold = radiusSquared;
    }

    public IntRAC(int[][] bKeys, int subSamples, int nClusters) {
        this();
        distances = new int[subSamples][subSamples];
        int j = 0;
        this.threshold = 0.0;
        int thresholdIteration = 5;
        while (j++ < 5) {
            int[][] randomList = new int[subSamples][];
            int[] randomListIndex = RandomData.getUniqueRandomInts((int)subSamples, (int)0, (int)bKeys.length);
            int ri = 0;
            for (int k = 0; k < randomListIndex.length; ++k) {
                randomList[ri++] = bKeys[randomListIndex[k]];
            }
            try {
                this.threshold += IntRAC.calculateThreshold(randomList, nClusters);
            }
            catch (Exception e) {
                this.threshold += 200000.0;
            }
            System.out.println("Current threshold: " + this.threshold / (double)j);
        }
        this.threshold /= 5.0;
    }

    protected static double calculateThreshold(int[][] samples, int nClusters) throws MaxIterationsExceededException, FunctionEvaluationException {
        int maxDistance = 0;
        for (int i = 0; i < samples.length; ++i) {
            for (int j = i + 1; j < samples.length; ++j) {
                IntRAC.distances[i][j] = IntRAC.distanceEuclidianSquared(samples[i], samples[j]);
                IntRAC.distances[j][i] = distances[i][j];
                if (distances[i][j] <= maxDistance) continue;
                maxDistance = distances[i][j];
            }
        }
        System.out.println("Distance matrix calculated");
        BisectionSolver b = new BisectionSolver();
        b.setAbsoluteAccuracy(100.0);
        return b.solve(100, (UnivariateRealFunction)new ClusterMinimisationFunction(samples, distances, nClusters), 0.0, (double)maxDistance);
    }

    int train(int[][] samples, int[][] distances) {
        int foundLength = -1;
        ArrayList<Integer> codebookIndex = new ArrayList<Integer>();
        for (int i = 0; i < samples.length; ++i) {
            int[] entry = samples[i];
            if (foundLength == -1) {
                foundLength = entry.length;
            }
            if (foundLength != entry.length) {
                this.codebook = new ArrayList();
                return -1;
            }
            boolean found = false;
            Iterator iterator = codebookIndex.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                if (!((double)distances[i][j] < this.threshold)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.codebook.add(entry);
            codebookIndex.add(i);
        }
        this.nDims = foundLength;
        return 0;
    }

    public IntRAC cluster(int[][] data) {
        int foundLength = -1;
        for (int[] entry : data) {
            if (foundLength == -1) {
                foundLength = entry.length;
            }
            if (foundLength != entry.length) {
                this.codebook = new ArrayList();
                throw new RuntimeException();
            }
            boolean found = false;
            for (int[] existing : this.codebook) {
                if (!((double)IntRAC.distanceEuclidianSquared(entry, existing) < this.threshold)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.codebook.add(entry);
            if (this.codebook.size() % 1000 != 0) continue;
            System.out.println("Codebook increased to size " + this.codebook.size());
        }
        return this;
    }

    @Override
    public IntRAC cluster(DataSource<int[]> data) {
        int[][] dataArr = new int[data.size()][data.numDimensions()];
        return this.cluster(dataArr);
    }

    static int distanceEuclidianSquared(int[] a, int[] b) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            int diff = a[i] - b[i];
            sum += diff * diff;
        }
        return sum;
    }

    static int distanceEuclidianSquared(int[] a, int[] b, int threshold2) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            int diff = a[i] - b[i];
            if ((sum += diff * diff) <= threshold2) continue;
            return threshold2;
        }
        return sum;
    }

    @Override
    public int numClusters() {
        return this.codebook.size();
    }

    @Override
    public int numDimensions() {
        return this.nDims;
    }

    public int[] assign(int[][] data) {
        int[] centroids = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            int[] entry = data[i];
            centroids[i] = this.assign(entry);
        }
        return centroids;
    }

    @Override
    public int assign(int[] data) {
        int mindiff = -1;
        int centroid = -1;
        for (int i = 0; i < this.numClusters(); ++i) {
            int[] centroids = this.codebook.get(i);
            int sum = 0;
            boolean set = true;
            for (int j = 0; j < centroids.length; ++j) {
                int diff = centroids[j] - data[j];
                if (mindiff == -1 || mindiff >= (sum += diff * diff)) continue;
                set = false;
                break;
            }
            if (!set) continue;
            mindiff = sum;
            centroid = i;
        }
        return centroid;
    }

    public String asciiHeader() {
        return "ASCIICLSTRAIC";
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner in) throws IOException {
        throw new UnsupportedOperationException("Not done!");
    }

    public void readBinary(DataInput dis) throws IOException {
        this.threshold = dis.readDouble();
        this.nDims = dis.readInt();
        int nClusters = dis.readInt();
        assert (this.threshold > 0.0);
        this.codebook = new ArrayList();
        for (int i = 0; i < nClusters; ++i) {
            byte[] wang = new byte[this.nDims];
            dis.readFully(wang, 0, this.nDims);
            int[] cluster = new int[this.nDims];
            for (int j = 0; j < this.nDims; ++j) {
                cluster[j] = wang[j] & 0xFF;
            }
            this.codebook.add(cluster);
        }
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        writer.format("%d\n", this.threshold);
        writer.format("%d\n", this.nDims);
        writer.format("%d\n", this.numClusters());
        for (int[] a : this.codebook) {
            writer.format("%d,", new Object[]{a});
        }
    }

    public void writeBinary(DataOutput dos) throws IOException {
        dos.writeDouble(this.threshold);
        dos.writeInt(this.nDims);
        dos.writeInt(this.numClusters());
        for (int[] arr : this.codebook) {
            for (int a : arr) {
                dos.write(a);
            }
        }
    }

    public int[][] getCentroids() {
        return (int[][])this.codebook.toArray((T[])new int[0][]);
    }

    public void assignDistance(int[][] data, int[] indices, float[] distances) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IntFloatPair assignDistance(int[] data) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public HardAssigner<int[], ?, ?> defaultHardAssigner() {
        return this;
    }

    @Override
    public int size() {
        return this.nDims;
    }

    public int[][] performClustering(int[][] data) {
        return new IndexClusters(this.cluster(data).defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    private static class ClusterMinimisationFunction
    implements UnivariateRealFunction {
        private int[][] distances;
        private int[][] samples;
        private int nClusters;

        public ClusterMinimisationFunction(int[][] samples, int[][] distances, int nClusters) {
            this.distances = distances;
            this.samples = samples;
            this.nClusters = nClusters;
        }

        public double value(double radius) throws FunctionEvaluationException {
            IntRAC r = new IntRAC(radius);
            r.train(this.samples, this.distances);
            int diff = this.nClusters - r.numClusters();
            return diff;
        }
    }
}

