/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.ByteCentroidsResult;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;

public class RandomByteClusterer
implements SpatialClusterer<ByteCentroidsResult, byte[]> {
    protected int M;
    protected int K;
    protected Random random;
    protected long seed;

    public RandomByteClusterer(int M, int K) {
        this.M = M;
        this.K = K;
        this.random = new Random();
        this.seed = -1L;
    }

    public RandomByteClusterer(int M) {
        this(M, -1);
    }

    public void setSeed(long seed) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.seed = seed;
    }

    public ByteCentroidsResult cluster(byte[][] data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.length;
        }
        ByteCentroidsResult result = new ByteCentroidsResult();
        result.centroids = new byte[nc][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.length);
            result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
        }
        return result;
    }

    public int[][] performClustering(byte[][] data) {
        ByteCentroidsResult res = this.cluster(data);
        return new IndexClusters(res.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    @Override
    public ByteCentroidsResult cluster(DataSource<byte[]> data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.size();
        }
        ByteCentroidsResult result = new ByteCentroidsResult();
        result.centroids = new byte[nc][this.M];
        byte[][] dataRow = new byte[1][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.size());
            dataRow[0] = result.centroids[i];
            data.getData(dIndex, dIndex + 1, (Object[])dataRow);
        }
        return result;
    }
}

