/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.IntCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusterer;

public class RandomIntClusterer
implements SpatialClusterer<IntCentroidsResult, int[]> {
    protected int M;
    protected int K;
    protected Random random;
    protected long seed;

    public RandomIntClusterer(int M, int K) {
        this.M = M;
        this.K = K;
        this.random = new Random();
        this.seed = -1L;
    }

    public RandomIntClusterer(int M) {
        this(M, -1);
    }

    public void setSeed(long seed) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.seed = seed;
    }

    public IntCentroidsResult cluster(int[][] data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.length;
        }
        IntCentroidsResult result = new IntCentroidsResult();
        result.centroids = new int[nc][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.length);
            result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
        }
        return result;
    }

    public int[][] performClustering(int[][] data) {
        IntCentroidsResult res = this.cluster(data);
        return new IndexClusters(res.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    @Override
    public IntCentroidsResult cluster(DataSource<int[]> data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.size();
        }
        IntCentroidsResult result = new IntCentroidsResult();
        result.centroids = new int[nc][this.M];
        int[][] dataRow = new int[1][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.size());
            dataRow[0] = result.centroids[i];
            data.getData(dIndex, dIndex + 1, (Object[])dataRow);
        }
        return result;
    }
}

