/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.rforest;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import org.openimaj.ml.clustering.rforest.RandomDecision;

public class RandomDecisionTree {
    List<RandomDecision> decisions;
    private Random random = new Random();

    public RandomDecisionTree(int nDecisions, int featureLength, int[] minVal, int[] maxVal) {
        this.initDecisions(nDecisions, featureLength, minVal, maxVal);
    }

    public RandomDecisionTree(int nDecisions, int featureLength, int[] minVal, int[] maxVal, Random r) {
        this.random = r;
        this.initDecisions(nDecisions, featureLength, minVal, maxVal);
    }

    private void initDecisions(int nDecisions, int featureLength, int[] minVal, int[] maxVal) {
        this.decisions = new LinkedList<RandomDecision>();
        for (int i = 0; i < nDecisions; ++i) {
            RandomDecision dec = new RandomDecision(featureLength, minVal, maxVal, this.random);
            this.decisions.add(dec);
        }
    }

    public RandomDecisionTree() {
        this.decisions = new LinkedList<RandomDecision>();
    }

    public boolean[] getLetter(int[] feature) {
        boolean[] out = new boolean[this.decisions.size()];
        int i = 0;
        for (RandomDecision r : this.decisions) {
            out[i] = feature[r.feature] > r.threshold;
            ++i;
        }
        return out;
    }

    public void write(DataOutput o) throws IOException {
        o.writeInt(this.decisions.size());
        for (RandomDecision r : this.decisions) {
            r.write(o);
        }
    }

    public void writeASCII(PrintWriter writer) {
        for (RandomDecision r : this.decisions) {
            r.writeASCII(writer);
            writer.print(" ");
        }
    }

    public RandomDecisionTree readBinary(DataInput dis) throws IOException {
        int nDecisions = dis.readInt();
        if (this.decisions.size() != nDecisions) {
            this.decisions = new LinkedList<RandomDecision>();
            for (int i = 0; i < nDecisions; ++i) {
                RandomDecision r = new RandomDecision().readBinary(dis);
                this.decisions.add(r);
            }
        } else {
            for (RandomDecision rd : this.decisions) {
                rd.readBinary(dis);
            }
        }
        return this;
    }

    public RandomDecisionTree readASCII(Scanner br) throws IOException {
        String[] lines = br.nextLine().split(" ");
        if (this.decisions.size() != lines.length) {
            this.decisions = new LinkedList<RandomDecision>();
            for (String line : lines) {
                this.decisions.add(new RandomDecision().readString(line));
            }
        } else {
            int index = 0;
            for (RandomDecision rd : this.decisions) {
                rd.readString(lines[index++]);
            }
        }
        return this;
    }

    public String toString() {
        String s = "{";
        for (RandomDecision r : this.decisions) {
            s = s + r.toString() + ",";
        }
        s = s + "}";
        return s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RandomDecisionTree)) {
            return false;
        }
        RandomDecisionTree rdt = (RandomDecisionTree)o;
        for (int i = 0; i < this.decisions.size(); ++i) {
            RandomDecision d1 = rdt.decisions.get(i);
            RandomDecision d2 = this.decisions.get(i);
            if (d1.feature == d2.feature && d1.threshold == d2.threshold) continue;
            return false;
        }
        return true;
    }
}

