/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.MultiviewSimilarityClusterer;
import org.openimaj.ml.clustering.spectral.DoubleSpectralClustering;
import org.openimaj.ml.clustering.spectral.MultiviewSpectralClusteringConf;
import org.openimaj.ml.clustering.spectral.PreparedSpectralClustering;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Incollection, author={"Abhishek Kumar", "Piyush Rai", "Hal Daume III"}, title="Co-regularized Multi-view Spectral Clustering", year="2011", booktitle="Advances in Neural Information Processing Systems 24", pages={"1413", "", "1421"}, editor={"J. Shawe-Taylor", "R.S. Zemel", "P. Bartlett", "F.C.N. Pereira", "K.Q. Weinberger"})
public class DoubleMultiviewSpectralClustering
implements MultiviewSimilarityClusterer<IndexClusters> {
    private MultiviewSpectralClusteringConf<double[]> conf;

    public DoubleMultiviewSpectralClustering(MultiviewSpectralClusteringConf<double[]> conf) {
        this.conf = conf;
    }

    @Override
    public IndexClusters cluster(List<SparseMatrix> data) {
        int i;
        DoubleSpectralClustering dsp = new DoubleSpectralClustering(this.conf);
        if (data.size() == 1) {
            return dsp.cluster(data.get(0));
        }
        ArrayList<IndependentPair<double[], double[][]>> answers = new ArrayList<IndependentPair<double[], double[][]>>(data.size());
        PreparedSpectralClustering prep = new PreparedSpectralClustering(this.conf);
        for (i = 0; i < data.size(); ++i) {
            answers.add(prep.bestCols(dsp.spectralCluster(data.get(i))));
        }
        while (!this.conf.stop.stop(answers)) {
            for (i = 0; i < answers.size(); ++i) {
                SparseMatrix laplacian = dsp.laplacian(data.get(i));
                SparseMatrix ujujSum = null;
                for (int j = 0; j < answers.size(); ++j) {
                    if (i == j) continue;
                    DenseMatrix uj = new DenseMatrix((double[][])answers.get(j).secondObject());
                    SparseMatrix ujuj = (SparseMatrix)MatlibMatrixUtils.dotProductTranspose((Matrix)uj, (Matrix)uj, (Matrix)new SparseMatrix(uj.rowCount(), uj.rowCount()));
                    if (ujujSum == null) {
                        ujujSum = ujuj;
                        continue;
                    }
                    MatlibMatrixUtils.plusInplace((SparseMatrix)ujujSum, (Matrix)ujuj);
                }
                MatlibMatrixUtils.plusInplace((SparseMatrix)laplacian, (Matrix)MatlibMatrixUtils.scaleInplace(ujujSum, (double)this.conf.lambda));
                answers.add(i, prep.bestCols(dsp.laplacianEigenVectors(laplacian)));
            }
        }
        return null;
    }

    public int[][] performClustering(List<SparseMatrix> data) {
        return this.cluster(data).clusters();
    }
}

