/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.connectedcomponent.ConnectedComponentLabeler;
import org.openimaj.image.model.pixel.HistogramPixelModel;
import org.openimaj.image.model.pixel.MBFPixelClassificationModel;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processing.convolution.FSobelMagnitude;
import org.openimaj.image.processing.face.detection.CCDetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processor.SinglebandKernelProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.image.processor.connectedcomponent.render.OrientatedBoundingBoxRenderer;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Article, author={"Sandeep, K", "Rajagopalan, A N"}, title="Human Face Detection in Cluttered Color Images Using Skin Color and Edge Information", year="2002", journal="Electrical Engineering", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.12.730&rep=rep1&type=pdf", publisher="Citeseer")
public class SandeepFaceDetector
implements FaceDetector<CCDetectedFace, MBFImage> {
    public static final double GOLDEN_RATIO = 1.618033989;
    private final String DEFAULT_MODEL = "/org/openimaj/image/processing/face/detection/skin-histogram-16-6.bin";
    private ConnectedComponentLabeler ccl = new ConnectedComponentLabeler(ConnectedComponent.ConnectMode.CONNECT_8);
    MBFPixelClassificationModel skinModel;
    float skinThreshold = 0.1f;
    float edgeThreshold = 0.49019608f;
    float goldenRatioThreshold = 0.65f;
    float percentageThreshold = 0.55f;

    public SandeepFaceDetector() {
        try {
            if (this.getClass().getResource("/org/openimaj/image/processing/face/detection/skin-histogram-16-6.bin") == null) {
                this.skinModel = new HistogramPixelModel(new int[]{16, 6});
                MBFImage rgb = ImageUtilities.readMBF((InputStream)this.getClass().getResourceAsStream("skin.png"));
                this.skinModel.learnModel((Image[])new MBFImage[]{Transforms.RGB_TO_HS((MBFImage)rgb)});
            } else {
                ObjectInputStream ois = new ObjectInputStream(this.getClass().getResourceAsStream("/org/openimaj/image/processing/face/detection/skin-histogram-16-6.bin"));
                this.skinModel = (MBFPixelClassificationModel)ois.readObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public SandeepFaceDetector(MBFPixelClassificationModel skinModel) {
        this.skinModel = skinModel;
    }

    protected FImage generateSkinColorMap(MBFImage inputHS) {
        FImage map = this.skinModel.predict((Image)inputHS);
        map.clipMin(Float.valueOf(this.skinThreshold));
        return map;
    }

    protected FImage generateSobelMagnitudes(MBFImage inputRGB) {
        MBFImage mag = (MBFImage)inputRGB.process((SinglebandKernelProcessor)new FSobelMagnitude());
        FImage ret = mag.flattenMax().clipMax(Float.valueOf(this.edgeThreshold));
        return ret;
    }

    protected FImage generateFaceMap(FImage skin, FImage edge) {
        for (int y = 0; y < skin.height; ++y) {
            for (int x = 0; x < skin.height; ++x) {
                skin.pixels[y][x] = edge.pixels[y][x] != 0.0f && skin.pixels[y][x] != 0.0f ? 1.0f : 0.0f;
            }
        }
        return skin;
    }

    protected List<CCDetectedFace> extractFaces(FImage faceMap, FImage skinMap, FImage image) {
        List blobs = this.ccl.findComponents(faceMap);
        ArrayList<CCDetectedFace> faces = new ArrayList<CCDetectedFace>();
        for (ConnectedComponent blob : blobs) {
            if (blob.calculateArea() <= 1000) continue;
            double[] centroid = blob.calculateCentroid();
            double[] hw = blob.calculateAverageHeightWidth(centroid);
            double percentageSkin = this.calculatePercentageSkin(skinMap, (int)Math.round(centroid[0] - hw[0] / 2.0), (int)Math.round(centroid[1] - hw[1] / 2.0), (int)Math.round(centroid[0] + hw[0] / 2.0), (int)Math.round(centroid[1] + hw[1] / 2.0));
            double ratio = hw[0] / hw[1];
            if (!(Math.abs(ratio - 1.618033989) < (double)this.goldenRatioThreshold) || !(percentageSkin > (double)this.percentageThreshold)) continue;
            Rectangle r = blob.calculateRegularBoundingBox();
            faces.add(new CCDetectedFace(r, (FImage)image.extractROI(r), blob, (float)(percentageSkin / (double)this.percentageThreshold * (Math.abs(ratio - 1.618033989) / (double)this.goldenRatioThreshold))));
        }
        return faces;
    }

    private double calculatePercentageSkin(FImage skinMap, int l, int t, int r, int b) {
        int npix = 0;
        int nskin = 0;
        l = Math.max(l, 0);
        t = Math.max(t, 0);
        r = Math.min(r, skinMap.getWidth());
        b = Math.min(b, skinMap.getHeight());
        for (int y = t; y < b; ++y) {
            for (int x = l; x < r; ++x) {
                ++npix;
                if (skinMap.pixels[y][x] == 0.0f) continue;
                ++nskin;
            }
        }
        return (double)nskin / (double)npix;
    }

    @Override
    public List<CCDetectedFace> detectFaces(MBFImage inputRGB) {
        FImage skin = this.generateSkinColorMap(Transforms.RGB_TO_HS((MBFImage)inputRGB));
        FImage edge = this.generateSobelMagnitudes(inputRGB);
        FImage map = this.generateFaceMap(skin, edge);
        return this.extractFaces(map, skin, Transforms.calculateIntensityNTSC((MBFImage)inputRGB));
    }

    public MBFPixelClassificationModel getSkinModel() {
        return this.skinModel;
    }

    public void setSkinModel(MBFPixelClassificationModel skinModel) {
        this.skinModel = skinModel;
    }

    public float getSkinThreshold() {
        return this.skinThreshold;
    }

    public void setSkinThreshold(float skinThreshold) {
        this.skinThreshold = skinThreshold;
    }

    public float getEdgeThreshold() {
        return this.edgeThreshold;
    }

    public void setEdgeThreshold(float edgeThreshold) {
        this.edgeThreshold = edgeThreshold;
    }

    public float getPercentageThreshold() {
        return this.percentageThreshold;
    }

    public void setPercentageThreshold(float percentageThreshold) {
        this.percentageThreshold = percentageThreshold;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: SandeepFaceDetector filename [filename_out]");
            return;
        }
        String inputImage = args[0];
        String outputImage = null;
        if (args.length == 2) {
            outputImage = args[1];
        }
        SandeepFaceDetector sfd = new SandeepFaceDetector();
        sfd.edgeThreshold = 0.39f;
        sfd.ccl = new ConnectedComponentLabeler(ConnectedComponent.ConnectMode.CONNECT_4);
        MBFImage image = ImageUtilities.readMBF((File)new File(inputImage));
        List<CCDetectedFace> faces = sfd.detectFaces(image);
        if (outputImage != null) {
            OrientatedBoundingBoxRenderer render = new OrientatedBoundingBoxRenderer(image.getWidth(), image.getHeight(), (Object)Float.valueOf(1.0f));
            for (CCDetectedFace f : faces) {
                f.connectedComponent.process((ConnectedComponentProcessor)render);
            }
            image.multiplyInplace(render.getImage().inverse());
            ImageUtilities.write((Image)image, (String)outputImage.substring(outputImage.lastIndexOf(46) + 1), (File)new File(outputImage));
        }
        for (CCDetectedFace f : faces) {
            System.out.format("%s, %d, %d, %d, %d\n", "uk.ac.soton.ecs.jsh2.image.proc.tools.face.detection.skin-histogram-16-6.bin", Float.valueOf(f.bounds.x), Float.valueOf(f.bounds.y), Float.valueOf(f.bounds.width), Float.valueOf(f.bounds.height));
        }
    }

    public void readBinary(DataInput in) throws IOException {
        try {
            byte[] bytes = new byte[in.readInt()];
            in.readFully(bytes);
            this.skinModel = (MBFPixelClassificationModel)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.skinThreshold = in.readFloat();
        this.edgeThreshold = in.readFloat();
        this.goldenRatioThreshold = in.readFloat();
        this.percentageThreshold = in.readFloat();
    }

    public byte[] binaryHeader() {
        return "SdFD".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.skinModel);
        oos.close();
        out.writeInt(baos.size());
        out.write(baos.toByteArray());
        out.writeFloat(this.skinThreshold);
        out.writeFloat(this.edgeThreshold);
        out.writeFloat(this.goldenRatioThreshold);
        out.writeFloat(this.percentageThreshold);
    }
}

