/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.benchmarking;

import gnu.trove.set.hash.TDoubleHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.image.objectdetection.filtering.DetectionFilter;
import org.openimaj.image.objectdetection.filtering.OpenCVGrouping;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;
import org.openimaj.image.processing.face.detection.benchmarking.FDDBDataset;
import org.openimaj.image.processing.face.detection.benchmarking.FDDBRecord;
import org.openimaj.image.processing.face.detection.benchmarking.Matcher;
import org.openimaj.image.processing.face.detection.benchmarking.Results;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.ObjectIntPair;

public class FDDBEvaluation {
    public List<Results> performEvaluation(ListDataset<FDDBRecord> dataset, EvaluationDetector detector) {
        List<Results> cumRes = new ArrayList<Results>();
        Matcher matcher = new Matcher();
        int numImages = dataset.size();
        for (int i = 0; i < numImages; ++i) {
            FDDBRecord data = (FDDBRecord)dataset.getInstance(i);
            String imName = data.getImageName();
            List<? extends DetectedFace> annot = data.getGroundTruth();
            List<? extends DetectedFace> det = detector.getDetections(data);
            ArrayList<Results> imageResults = new ArrayList<Results>();
            if (det.size() == 0) {
                Results r = new Results(imName, Double.MAX_VALUE, null, annot, det);
                imageResults.add(r);
            } else {
                double[] uniqueScores;
                for (double scoreThreshold : uniqueScores = this.getUniqueConfidences(det)) {
                    ArrayList<DetectedFace> filteredDet = new ArrayList<DetectedFace>();
                    for (int di = 0; di < det.size(); ++di) {
                        DetectedFace rd = det.get(di);
                        if (!((double)rd.getConfidence() >= scoreThreshold)) continue;
                        filteredDet.add(rd);
                    }
                    List<Matcher.Match> mps = matcher.match(annot, filteredDet);
                    Results r = new Results(imName, scoreThreshold, mps, annot, filteredDet);
                    imageResults.add(r);
                }
            }
            cumRes = Results.merge(cumRes, imageResults);
        }
        return cumRes;
    }

    private double[] getUniqueConfidences(List<? extends DetectedFace> faces) {
        TDoubleHashSet set = new TDoubleHashSet();
        for (DetectedFace detectedFace : faces) {
            set.add((double)detectedFace.getConfidence());
        }
        double[] ret = set.toArray();
        Arrays.sort(ret);
        return ret;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        File fddbGroundTruth = new File("/Users/jsh2/Downloads/FDDB-folds/FDDB-fold-01-ellipseList.txt");
        File imageBase = new File("/Users/jsh2/Downloads/originalPics/");
        FDDBDataset dataset = new FDDBDataset(fddbGroundTruth, imageBase, true);
        final HaarCascadeDetector det = HaarCascadeDetector.BuiltInCascade.frontalface_alt2.load();
        det.setGroupingFilter((DetectionFilter<Rectangle, ObjectIntPair<Rectangle>>)new OpenCVGrouping(0));
        det.setMinSize(80);
        EvaluationDetector evDet = new EvaluationDetector(){

            @Override
            public synchronized List<? extends DetectedFace> getDetections(FDDBRecord record) {
                List<DetectedFace> faces = det.detectFaces(record.getFImage());
                return faces;
            }
        };
        FDDBEvaluation eval = new FDDBEvaluation();
        List<Results> result = eval.performEvaluation((ListDataset<FDDBRecord>)dataset, evDet);
        System.out.println(Results.getROCData(result));
    }

    public static interface EvaluationDetector {
        public List<? extends DetectedFace> getDetections(FDDBRecord var1);
    }
}

