/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.keypoints;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;

class MaskedHaarCascade {
    MaskedHaarCascade() {
    }

    static FImage maskedHaarCascade(SummedAreaTable integralImage, int wh, int ww, int[][] H, double[][] TA, boolean[][] M) {
        int ih = integralImage.data.height - 1;
        int iw = integralImage.data.width - 1;
        int nf = H.length;
        int nh = H[0].length;
        int[] HI = new int[nf * nh];
        int dp = 0;
        for (int h = 0; h < nh; ++h) {
            int f = 0;
            while (f < nf) {
                if (H[f][h] != 0) {
                    int ind;
                    int sign;
                    if (H[f][h] < 0) {
                        sign = -1;
                        ind = -H[f][h];
                    } else {
                        sign = 1;
                        ind = H[f][h];
                    }
                    int x = (ind - 1) / (wh + 1);
                    int y = ind - 1 - x * (wh + 1);
                    HI[dp] = (x * (ih + 1) + y + 1) * sign;
                }
                ++f;
                ++dp;
            }
        }
        FImage Q = new FImage(iw, ih);
        Q.fill(Float.NEGATIVE_INFINITY);
        int x1 = ww / 2;
        int x2 = iw - 1 - ww / 2;
        int y1 = wh / 2;
        int y2 = ih - 1 - wh / 2;
        int coloff = ih + y1 - y2 - 1;
        float[][] iimg = integralImage.data.pixels;
        float[][] Qpixels = Q.pixels;
        float[] iimgF = new float[integralImage.data.width * integralImage.data.height];
        int i = 0;
        for (int y = 0; y < iimg[0].length; ++y) {
            int x = 0;
            while (x < iimg.length) {
                iimgF[i] = iimg[x][y];
                ++x;
                ++i;
            }
        }
        int II = -1;
        int x = x1;
        while (x <= x2) {
            int y = y1;
            while (y <= y2) {
                if (M[y][x]) {
                    int hp = 0;
                    int tap = 0;
                    float q = 0.0f;
                    int h = 0;
                    while (h < nh) {
                        if (HI[hp] == 0) {
                            if ((double)q < TA[1][tap]) {
                                q = Float.NEGATIVE_INFINITY;
                                break;
                            }
                            if (h + 1 == nh) {
                                q = (float)((double)q - TA[1][tap]);
                                break;
                            }
                            q = 0.0f;
                            hp += nf;
                        } else {
                            float s = 0.0f;
                            int f = 0;
                            while (f < nf) {
                                int index;
                                if (HI[hp] == 0) {
                                    hp += nf - f;
                                    break;
                                }
                                if (HI[hp] < 0) {
                                    index = II - HI[hp];
                                    s -= iimgF[index];
                                } else {
                                    index = II + HI[hp];
                                    s += iimgF[index];
                                }
                                ++f;
                                ++hp;
                            }
                            q = (double)s >= TA[0][tap] ? (float)((double)q + TA[1][tap]) : (float)((double)q - TA[1][tap]);
                        }
                        ++h;
                        ++tap;
                    }
                    Qpixels[y][x] = q;
                }
                ++y;
                ++II;
            }
            ++x;
            II += coloff + 1;
        }
        return Q;
    }
}

