/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.convolution.Gaussian2D;
import org.openimaj.image.processing.convolution.LaplacianOfGaussian2D;
import org.openimaj.image.processing.convolution.filterbank.FilterBank;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class LeungMalikFilterBank
extends FilterBank {
    public LeungMalikFilterBank() {
        this(49);
    }

    public LeungMalikFilterBank(int size) {
        super(LeungMalikFilterBank.makeFilters(size));
    }

    protected static FConvolution[] makeFilters(int size) {
        float scale;
        int i;
        int nScales = 3;
        int nOrientations = 6;
        int NROTINV = 12;
        int NBAR = 18;
        int NEDGE = 18;
        int NF = 48;
        FConvolution[] F = new FConvolution[48];
        int count = 0;
        for (i = 1; i <= 3; ++i) {
            scale = (float)Math.pow(Math.sqrt(2.0), i);
            for (int orient = 0; orient < 6; ++orient) {
                float angle = (float)(Math.PI * (double)orient / 6.0);
                F[count] = new FConvolution(LeungMalikFilterBank.makeFilter(scale, 0, 1, angle, size));
                F[count + 18] = new FConvolution(LeungMalikFilterBank.makeFilter(scale, 0, 2, angle, size));
                ++count;
            }
        }
        count = 36;
        for (i = 1; i <= 4; ++i) {
            scale = (float)Math.pow(Math.sqrt(2.0), i);
            F[count] = new FConvolution(LeungMalikFilterBank.normalise(Gaussian2D.createKernelImage(size, scale)));
            F[count + 1] = new FConvolution(LeungMalikFilterBank.normalise(LaplacianOfGaussian2D.createKernelImage(size, scale)));
            F[count + 2] = new FConvolution(LeungMalikFilterBank.normalise(LaplacianOfGaussian2D.createKernelImage(size, 3.0f * scale)));
            count += 3;
        }
        return F;
    }

    protected static FImage makeFilter(float scale, int phasex, int phasey, float angle, int size) {
        int hs = (size - 1) / 2;
        FImage filter = new FImage(size, size);
        int y = -hs;
        int j = 0;
        while (y < hs) {
            int x = -hs;
            int i = 0;
            while (x < hs) {
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float rx = cos * (float)x - sin * (float)y;
                float ry = sin * (float)x + cos * (float)y;
                float gx = LeungMalikFilterBank.gaussian1D(3.0f * scale, 0.0f, rx, phasex);
                float gy = LeungMalikFilterBank.gaussian1D(scale, 0.0f, ry, phasey);
                filter.pixels[j][i] = gx * gy;
                ++x;
                ++i;
            }
            ++y;
            ++j;
        }
        return LeungMalikFilterBank.normalise(filter);
    }

    protected static float gaussian1D(float sigma, float mean, float x, int order) {
        float num = (x -= mean) * x;
        float variance = sigma * sigma;
        float denom = 2.0f * variance;
        float g = (float)(Math.exp(-num / denom) / Math.pow(Math.PI * (double)denom, 0.5));
        switch (order) {
            case 0: {
                return g;
            }
            case 1: {
                return -g * (x / variance);
            }
            case 2: {
                return g * ((num - variance) / (variance * variance));
            }
        }
        throw new IllegalArgumentException("order must be 0, 1 or 2.");
    }

    protected static FImage normalise(FImage f) {
        float mean = FloatArrayStatsUtils.mean((float[][])f.pixels);
        f.subtractInplace(Float.valueOf(mean));
        float sumabs = FloatArrayStatsUtils.sumAbs((float[][])f.pixels);
        return f.divideInplace(sumabs);
    }
}

