/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import org.openimaj.image.FImage;
import org.openimaj.image.combiner.ImageCombiner;

public class NonMaximumSuppressionTangent
implements ImageCombiner<FImage, FImage, FImage> {
    public static FImage computeSuppressed(FImage dxImage, FImage dyImage) {
        return NonMaximumSuppressionTangent.computeSuppressed(dxImage, dyImage, null);
    }

    public static FImage computeSuppressed(FImage dxImage, FImage dyImage, FImage magsOut) {
        float[][] diffx = dxImage.pixels;
        float[][] diffy = dyImage.pixels;
        int width = dxImage.width;
        int height = dxImage.height;
        float[][] mag = magsOut == null ? new float[height][width] : magsOut.pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mag[y][x] = (float)Math.sqrt(diffx[y][x] * diffx[y][x] + diffy[y][x] * diffy[y][x]);
            }
        }
        FImage outimg = new FImage(width, height);
        float[][] output = outimg.pixels;
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                float val;
                float point;
                float B;
                float A;
                float b2;
                float b1;
                float a2;
                float a1;
                int dx = diffx[y][x] > 0.0f ? 1 : -1;
                int dy = diffy[y][x] > 0.0f ? -1 : 1;
                if (Math.abs(diffx[y][x]) > Math.abs(diffy[y][x])) {
                    a1 = mag[y][x + dx];
                    a2 = mag[y - dy][x + dx];
                    b1 = mag[y][x - dx];
                    b2 = mag[y + dy][x - dx];
                    A = (Math.abs(diffx[y][x]) - Math.abs(diffy[y][x])) * a1 + Math.abs(diffy[y][x]) * a2;
                    B = (Math.abs(diffx[y][x]) - Math.abs(diffy[y][x])) * b1 + Math.abs(diffy[y][x]) * b2;
                    point = mag[y][x] * Math.abs(diffx[y][x]);
                    if (point >= A && point > B) {
                        output[y][x] = val = Math.abs(diffx[y][x]);
                        continue;
                    }
                    output[y][x] = val = 0.0f;
                    continue;
                }
                a1 = mag[y - dy][x];
                a2 = mag[y - dy][x + dx];
                b1 = mag[y + dy][x];
                b2 = mag[y + dy][x - dx];
                A = (Math.abs(diffy[y][x]) - Math.abs(diffx[y][x])) * a1 + Math.abs(diffx[y][x]) * a2;
                B = (Math.abs(diffy[y][x]) - Math.abs(diffx[y][x])) * b1 + Math.abs(diffx[y][x]) * b2;
                point = mag[y][x] * Math.abs(diffy[y][x]);
                output[y][x] = point >= A && point > B ? (val = Math.abs(diffy[y][x])) : (val = 0.0f);
            }
        }
        return outimg;
    }

    public FImage combine(FImage dxImage, FImage dyImage) {
        return NonMaximumSuppressionTangent.computeSuppressed(dxImage, dyImage);
    }
}

