/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.effects;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.line.Line2d;

public class DioramaEffect
implements SinglebandImageProcessor<Float, FImage> {
    Line2d axis;

    public DioramaEffect(Line2d axis) {
        this.axis = axis;
    }

    public Line2d getAxis() {
        return this.axis;
    }

    public void setAxis(Line2d axis) {
        this.axis = axis;
    }

    public void processImage(FImage image) {
        this.render(image, new SummedAreaTable(image), (int)this.axis.getBeginPoint().getX(), (int)this.axis.getBeginPoint().getY(), (int)this.axis.getEndPoint().getX(), (int)this.axis.getEndPoint().getY());
    }

    private void render(FImage image, SummedAreaTable sat, int x1, int y1, int x2, int y2) {
        int w = image.width;
        int h = image.height;
        double s = (double)(w + h) * 2.0;
        int dx = x2 - x1;
        int dy = y2 - y1;
        float[][] pixels = image.pixels;
        for (int y = 0; y < h; ++y) {
            double yt = y - y1;
            for (int x = 0; x < w; ++x) {
                double xt = x - x1;
                double r = ((double)dx * xt + (double)dy * yt) / s;
                int ri = r < 0.0 ? (int)(-r) : (int)r;
                int yMin = Math.max(0, y - ri);
                int yMax = Math.min(h, y + ri);
                int bh = yMax - yMin;
                if (bh == 0) continue;
                int xMin = Math.max(0, x - ri);
                int xMax = Math.min(w, x + ri);
                float scale = 1.0f / (float)(xMax - xMin) / (float)bh;
                pixels[y][x] = sat.calculateArea(xMin, yMin, xMax, yMax) * scale;
            }
        }
    }
}

