/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ByteFVComparison;
import org.openimaj.lsh.functions.ByteHashFunction;
import org.openimaj.lsh.functions.ByteHashFunctionFactory;
import org.openimaj.lsh.functions.HammingHelper;
import org.openimaj.util.array.SparseByteArray;

@Reference(type=ReferenceType.Inproceedings, author={"Indyk, Piotr", "Motwani, Rajeev"}, title="Approximate nearest neighbors: towards removing the curse of dimensionality", year="1998", booktitle="Proceedings of the thirtieth annual ACM symposium on Theory of computing", pages={"604", "", "613"}, url="http://doi.acm.org/10.1145/276698.276876", publisher="ACM", series="STOC '98")
public class ByteHammingFactory
extends ByteHashFunctionFactory {
    int bitsPerDim;

    public ByteHammingFactory(int ndims, MersenneTwister rng, int bitsPerDim) {
        super(ndims, rng);
        this.bitsPerDim = bitsPerDim;
    }

    public Function create() {
        return new Function(this, this.ndims, this.rng);
    }

    @Override
    public ByteFVComparison fvDistanceFunction() {
        if (this.bitsPerDim == 0) {
            return ByteFVComparison.HAMMING;
        }
        return ByteFVComparison.PACKED_HAMMING;
    }

    private class Function
    extends ByteHashFunction {
        private int ham;

        Function(ByteHammingFactory options, int ndims, MersenneTwister rng) {
            super(rng);
            Uniform uniform = new Uniform((RandomEngine)rng);
            this.ham = options.bitsPerDim == 0 ? uniform.nextIntFromTo(0, ndims - 1) : uniform.nextIntFromTo(0, ndims * options.bitsPerDim - 1);
        }

        public int computeHashCode(byte[] point) {
            if (ByteHammingFactory.this.bitsPerDim == 0) {
                return point[this.ham] == 0 ? 0 : 1;
            }
            int m = this.ham % ByteHammingFactory.this.bitsPerDim;
            int d = this.ham / ByteHammingFactory.this.bitsPerDim;
            return (int)((long)(HammingHelper.convert(point[d]) >>> m) & 1L);
        }

        @Override
        public int computeHashCode(SparseByteArray array) {
            if (ByteHammingFactory.this.bitsPerDim == 0) {
                return array.get(this.ham) == 0 ? 0 : 1;
            }
            int m = this.ham % ByteHammingFactory.this.bitsPerDim;
            int d = this.ham / ByteHammingFactory.this.bitsPerDim;
            return (int)((long)(HammingHelper.convert(array.get(d)) >>> m) & 1L);
        }
    }
}

