/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.feature.FloatFVComparison;
import org.openimaj.lsh.functions.FloatPStableFactory;

public class FloatGaussianFactory
extends FloatPStableFactory {
    public FloatGaussianFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng, w);
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected FloatFVComparison fvDistanceFunction() {
        return FloatFVComparison.EUCLIDEAN;
    }

    private class Function
    extends FloatPStableFactory.PStableFunction {
        Function(int ndims, MersenneTwister rng) {
            super(FloatGaussianFactory.this, rng);
            Uniform uniform = new Uniform(0.0, FloatGaussianFactory.this.w, (RandomEngine)rng);
            Normal normal = new Normal(0.0, 1.0, (RandomEngine)rng);
            this.b = (float)uniform.nextDouble();
            this.r = new double[ndims];
            for (int i = 0; i < ndims; ++i) {
                this.r[i] = normal.nextDouble();
            }
        }
    }
}

