/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.IntFVComparison;
import org.openimaj.lsh.functions.IntHashFunction;
import org.openimaj.lsh.functions.IntHashFunctionFactory;
import org.openimaj.util.array.SparseIntArray;

@Reference(type=ReferenceType.Inproceedings, author={"Lv, Qin", "Charikar, Moses", "Li, Kai"}, title="Image similarity search with compact data structures", year="2004", booktitle="Proceedings of the thirteenth ACM international conference on Information and knowledge management", pages={"208", "", "217"}, url="http://doi.acm.org/10.1145/1031171.1031213", publisher="ACM", series="CIKM '04")
public class IntHyperplaneL1Factory
extends IntHashFunctionFactory {
    int min = 0;
    int max = 1;

    public IntHyperplaneL1Factory(int ndims, MersenneTwister rng, int min, int max) {
        super(ndims, rng);
        this.min = min;
        this.max = max;
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected IntFVComparison fvDistanceFunction() {
        return IntFVComparison.CITY_BLOCK;
    }

    private class Function
    extends IntHashFunction {
        int dimension;
        double shift;

        Function(int ndims, MersenneTwister rng) {
            super(rng);
            Uniform uniform = new Uniform((RandomEngine)rng);
            this.dimension = uniform.nextIntFromTo(0, ndims - 1);
            this.shift = uniform.nextDoubleFromTo((double)IntHyperplaneL1Factory.this.min, (double)IntHyperplaneL1Factory.this.max);
        }

        public int computeHashCode(int[] point) {
            return (double)point[this.dimension] - this.shift >= 0.0 ? 1 : 0;
        }

        @Override
        public int computeHashCode(SparseIntArray array) {
            return (double)array.get(this.dimension) - this.shift >= 0.0 ? 1 : 0;
        }
    }
}

