/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.calib3d;

import org.opencv.core.Mat;

public class StereoBM {
    protected final long nativeObj;
    public static final int PREFILTER_NORMALIZED_RESPONSE = 0;
    public static final int PREFILTER_XSOBEL = 1;
    public static final int BASIC_PRESET = 0;
    public static final int FISH_EYE_PRESET = 1;
    public static final int NARROW_PRESET = 2;

    protected StereoBM(long addr) {
        this.nativeObj = addr;
    }

    public StereoBM() {
        this.nativeObj = StereoBM.StereoBM_0();
    }

    public StereoBM(int preset, int ndisparities, int SADWindowSize) {
        this.nativeObj = StereoBM.StereoBM_1(preset, ndisparities, SADWindowSize);
    }

    public StereoBM(int preset) {
        this.nativeObj = StereoBM.StereoBM_2(preset);
    }

    public void compute(Mat left, Mat right, Mat disparity, int disptype) {
        StereoBM.compute_0(this.nativeObj, left.nativeObj, right.nativeObj, disparity.nativeObj, disptype);
    }

    public void compute(Mat left, Mat right, Mat disparity) {
        StereoBM.compute_1(this.nativeObj, left.nativeObj, right.nativeObj, disparity.nativeObj);
    }

    protected void finalize() throws Throwable {
        StereoBM.delete(this.nativeObj);
    }

    private static native long StereoBM_0();

    private static native long StereoBM_1(int var0, int var1, int var2);

    private static native long StereoBM_2(int var0);

    private static native void compute_0(long var0, long var2, long var4, long var6, int var8);

    private static native void compute_1(long var0, long var2, long var4, long var6);

    private static native void delete(long var0);
}

