/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryValueOperator;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantOptimizer
implements QueryOptimizer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final EvaluationStrategy strategy;

    public ConstantOptimizer(EvaluationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new ConstantVisitor());
    }

    protected class ConstantVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected ConstantVisitor() {
        }

        public void meet(Or or) {
            or.visitChildren((QueryModelVisitor)this);
            try {
                if (this.isConstant(or.getLeftArg()) && this.isConstant(or.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue((ValueExpr)or, EmptyBindingSet.getInstance());
                    or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.valueOf((boolean)value)));
                } else if (this.isConstant(or.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(or.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.TRUE));
                    } else {
                        or.replaceWith((QueryModelNode)or.getRightArg());
                    }
                } else if (this.isConstant(or.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(or.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        or.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.TRUE));
                    } else {
                        or.replaceWith((QueryModelNode)or.getLeftArg());
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        public void meet(And and) {
            and.visitChildren((QueryModelVisitor)this);
            try {
                if (this.isConstant(and.getLeftArg()) && this.isConstant(and.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue((ValueExpr)and, EmptyBindingSet.getInstance());
                    and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.valueOf((boolean)value)));
                } else if (this.isConstant(and.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(and.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        and.replaceWith((QueryModelNode)and.getRightArg());
                    } else {
                        and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.FALSE));
                    }
                } else if (this.isConstant(and.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(and.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        and.replaceWith((QueryModelNode)and.getLeftArg());
                    } else {
                        and.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.FALSE));
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        protected void meetBinaryValueOperator(BinaryValueOperator binaryValueOp) {
            super.meetBinaryValueOperator(binaryValueOp);
            if (this.isConstant(binaryValueOp.getLeftArg()) && this.isConstant(binaryValueOp.getRightArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate((ValueExpr)binaryValueOp, EmptyBindingSet.getInstance());
                    binaryValueOp.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        protected void meetUnaryValueOperator(UnaryValueOperator unaryValueOp) {
            super.meetUnaryValueOperator(unaryValueOp);
            if (this.isConstant(unaryValueOp.getArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate((ValueExpr)unaryValueOp, EmptyBindingSet.getInstance());
                    unaryValueOp.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        public void meet(FunctionCall functionCall) {
            super.meet(functionCall);
            List args = functionCall.getArgs();
            for (ValueExpr arg : args) {
                if (this.isConstant(arg)) continue;
                return;
            }
            try {
                Value value = ConstantOptimizer.this.strategy.evaluate((ValueExpr)functionCall, EmptyBindingSet.getInstance());
                functionCall.replaceWith((QueryModelNode)new ValueConstant(value));
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
            }
        }

        public void meet(Bound bound) {
            super.meet(bound);
            if (bound.getArg().hasValue()) {
                bound.replaceWith((QueryModelNode)new ValueConstant((Value)BooleanLiteralImpl.TRUE));
            }
        }

        public void meet(If node) {
            super.meet(node);
            if (this.isConstant(node.getCondition())) {
                try {
                    if (ConstantOptimizer.this.strategy.isTrue(node.getCondition(), EmptyBindingSet.getInstance())) {
                        node.replaceWith((QueryModelNode)node.getResult());
                    } else {
                        node.replaceWith((QueryModelNode)node.getAlternative());
                    }
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        public void meet(Regex node) {
            super.meetNode((QueryModelNode)node);
            if (this.isConstant(node.getArg()) && this.isConstant(node.getPatternArg()) && this.isConstant(node.getFlagsArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate((ValueExpr)node, EmptyBindingSet.getInstance());
                    node.replaceWith((QueryModelNode)new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", (Throwable)((Object)e));
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", (Throwable)e);
                }
            }
        }

        private boolean isConstant(ValueExpr expr) {
            return expr instanceof ValueConstant || expr instanceof Var && ((Var)expr).hasValue();
        }
    }
}

