/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

public class OrderElem
extends QueryModelNodeBase {
    private ValueExpr expr;
    private boolean ascending = true;

    public OrderElem() {
    }

    public OrderElem(ValueExpr expr) {
        this(expr, true);
    }

    public OrderElem(ValueExpr expr, boolean ascending) {
        this.setExpr(expr);
        this.setAscending(ascending);
    }

    public ValueExpr getExpr() {
        return this.expr;
    }

    public void setExpr(ValueExpr expr) {
        assert (expr != null) : "expr must not be null";
        expr.setParentNode(this);
        this.expr = expr;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.expr.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.expr == current) {
            this.setExpr((ValueExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " (" + (this.ascending ? "ASC" : "DESC") + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OrderElem) {
            OrderElem o = (OrderElem)other;
            return this.ascending == o.isAscending() && this.expr.equals(o.getExpr());
        }
        return false;
    }

    public int hashCode() {
        int result = this.expr.hashCode();
        if (this.ascending) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public OrderElem clone() {
        OrderElem clone = (OrderElem)super.clone();
        clone.setExpr(this.getExpr().clone());
        return clone;
    }
}

