/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import info.aduna.net.ParsedURI;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.NTriplesParserSettings;
import org.openrdf.rio.helpers.RDFParserHelper;

public abstract class AbstractRDFParser
implements RDFParser {
    private final MessageDigest md5;
    protected RDFHandler rdfHandler;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;
    protected ValueFactory valueFactory;
    private ParsedURI baseURI;
    private String nextBNodePrefix;
    private Map<String, String> namespaceTable;
    private ParserConfig parserConfig;

    public AbstractRDFParser() {
        this((ValueFactory)SimpleValueFactory.getInstance());
    }

    public AbstractRDFParser(ValueFactory valueFactory) {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.namespaceTable = new HashMap<String, String>(16);
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.setValueFactory(valueFactory);
        this.setParserConfig(new ParserConfig());
    }

    @Override
    public RDFParser setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
        return this;
    }

    @Override
    public RDFParser setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
        return this;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    @Override
    public RDFParser setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
        return this;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    @Override
    public RDFParser setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
        return this;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    @Override
    public RDFParser setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        this.initializeNamespaceTableFromConfiguration();
        return this;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet();
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        result.add(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        result.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
        result.add(BasicParserSettings.DATATYPE_HANDLERS);
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        result.add(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        result.add(BasicParserSettings.NORMALIZE_LANGUAGE_TAGS);
        result.add(BasicParserSettings.LANGUAGE_HANDLERS);
        result.add(BasicParserSettings.VERIFY_RELATIVE_URIS);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(BasicParserSettings.NAMESPACES);
        return result;
    }

    @Override
    public <T> RDFParser set(RioSetting<T> setting, T value) {
        this.getParserConfig().set((RioSetting)setting, (Object)value);
        return this;
    }

    @Override
    public void setVerifyData(boolean verifyData) {
        this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)verifyData);
    }

    @Deprecated
    public boolean verifyData() {
        return this.parserConfig.verifyData();
    }

    @Override
    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)preserveBNodeIDs);
    }

    public boolean preserveBNodeIDs() {
        return this.parserConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    @Override
    @Deprecated
    public void setStopAtFirstError(boolean stopAtFirstError) {
        this.getParserConfig().set((RioSetting)NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)stopAtFirstError);
        if (!stopAtFirstError) {
            this.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        } else {
            HashSet set = new HashSet(this.getParserConfig().getNonFatalErrors());
            set.remove(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            this.getParserConfig().setNonFatalErrors(set);
        }
    }

    @Deprecated
    public boolean stopAtFirstError() {
        return this.parserConfig.stopAtFirstError();
    }

    @Override
    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        if (datatypeHandling == RDFParser.DatatypeHandling.VERIFY) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        } else if (datatypeHandling == RDFParser.DatatypeHandling.NORMALIZE) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)true);
        } else if (!(this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES) || this.parserConfig.isSet(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES) || this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES))) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
            this.parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)false);
        }
    }

    @Deprecated
    public RDFParser.DatatypeHandling datatypeHandling() {
        return this.parserConfig.datatypeHandling();
    }

    protected void setBaseURI(String uriSpec) {
        ParsedURI baseURI = new ParsedURI(uriSpec);
        baseURI.normalize();
        this.setBaseURI(baseURI);
    }

    protected void setBaseURI(ParsedURI baseURI) {
        this.baseURI = baseURI;
    }

    protected void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
    }

    protected String getNamespace(String prefix) throws RDFParseException {
        if (this.namespaceTable.containsKey(prefix)) {
            return this.namespaceTable.get(prefix);
        }
        String msg = "Namespace prefix '" + prefix + "' used but not defined";
        if ("".equals(prefix)) {
            msg = "Default namespace used but not defined";
        }
        this.reportFatalError(msg);
        throw new RDFParseException(msg);
    }

    protected void clear() {
        this.baseURI = null;
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.namespaceTable.clear();
        this.initializeNamespaceTableFromConfiguration();
    }

    protected void initializeNamespaceTableFromConfiguration() {
        for (Namespace aNS : this.getParserConfig().get(BasicParserSettings.NAMESPACES)) {
            this.namespaceTable.put(aNS.getPrefix(), aNS.getName());
        }
    }

    @Deprecated
    protected void clearBNodeIDMap() {
    }

    protected IRI resolveURI(String uriSpec) throws RDFParseException {
        ParsedURI uri = new ParsedURI(uriSpec);
        if (uri.isRelative()) {
            if (this.baseURI == null) {
                this.reportFatalError("Unable to resolve URIs, no base URI has been set");
            }
            if (this.getParserConfig().get(BasicParserSettings.VERIFY_RELATIVE_URIS).booleanValue() && uri.isRelative() && !uri.isSelfReference() && this.baseURI.isOpaque()) {
                this.reportError("Relative URI '" + uriSpec + "' cannot be resolved using the opaque base URI '" + this.baseURI + "'", BasicParserSettings.VERIFY_RELATIVE_URIS);
            }
            uri = this.baseURI.resolve(uri);
        }
        return this.createURI(uri.toString());
    }

    protected IRI createURI(String uri) throws RDFParseException {
        try {
            return this.valueFactory.createIRI(uri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode() throws RDFParseException {
        try {
            return this.valueFactory.createBNode();
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode(String nodeID) throws RDFParseException {
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        String toAppend = nodeID;
        if (nodeID.length() > 32) {
            byte[] chars = null;
            try {
                chars = nodeID.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            toAppend = new HexBinaryAdapter().marshal(this.md5.digest(chars));
        }
        return this.valueFactory.createBNode(this.nextBNodePrefix + toAppend);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype, long lineNo, long columnNo) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory, lineNo, columnNo);
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj, Resource context) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj, context);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected void reportLocation(long lineNo, long columnNo) {
        if (this.locationListener != null) {
            this.locationListener.parseLocationUpdate(lineNo, columnNo);
        }
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, -1L, -1L);
    }

    protected void reportWarning(String msg, long lineNo, long columnNo) {
        if (this.errListener != null) {
            this.errListener.warning(msg, lineNo, columnNo);
        }
    }

    protected void reportError(String msg, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, this.getParseErrorListener());
    }

    protected void reportFatalError(String msg, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, lineNo, columnNo, this.getParseErrorListener());
    }

    private final String createUniqueBNodePrefix() {
        return "genid-" + UUID.randomUUID().toString().replaceAll("-", "") + "-";
    }
}

