/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.rio.ParseErrorListener;

public class ParseErrorCollector
implements ParseErrorListener {
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<String> fatalErrors = new ArrayList<String>();

    @Override
    public void warning(String msg, long lineNo, long colNo) {
        this.warnings.add(msg + " (" + lineNo + ", " + colNo + ")");
    }

    @Override
    public void error(String msg, long lineNo, long colNo) {
        this.errors.add("[Rio error] " + msg + " (" + lineNo + ", " + colNo + ")");
    }

    @Override
    public void fatalError(String msg, long lineNo, long colNo) {
        this.fatalErrors.add("[Rio fatal] " + msg + " (" + lineNo + ", " + colNo + ")");
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<String> getFatalErrors() {
        return Collections.unmodifiableList(this.fatalErrors);
    }

    public void reset() {
        this.warnings.clear();
        this.errors.clear();
        this.fatalErrors.clear();
    }
}

