/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.FinalizeLocalVariables;
import org.openrewrite.staticanalysis.FinalizeMethodArguments;

public final class ReplaceOptionalIsPresentWithIfPresent
extends Recipe {
    private static final MethodMatcher OPTIONAL_IS_PRESENT = new MethodMatcher("java.util.Optional isPresent()");
    private static final MethodMatcher OPTIONAL_GET = new MethodMatcher("java.util.Optional get()");

    public String getDisplayName() {
        return "Replace `Optional#isPresent()` with `Optional#ifPresent()`";
    }

    public String getDescription() {
        return "Replace `Optional#isPresent()` with `Optional#ifPresent()`. Please note that this recipe is only suitable for if-blocks that lack an Else-block and have a single condition applied.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(OPTIONAL_IS_PRESENT), (TreeVisitor)new ReplaceOptionalIsPresentWithIfPresentVisitor());
    }

    @Generated
    public ReplaceOptionalIsPresentWithIfPresent() {
    }

    @Generated
    public String toString() {
        return "ReplaceOptionalIsPresentWithIfPresent()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceOptionalIsPresentWithIfPresent)) {
            return false;
        }
        ReplaceOptionalIsPresentWithIfPresent other = (ReplaceOptionalIsPresentWithIfPresent)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceOptionalIsPresentWithIfPresent;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ReplaceOptionalIsPresentWithIfPresentVisitor
    extends JavaVisitor<ExecutionContext> {
        private final List<J.Identifier> lambdaAccessibleVariables = new ArrayList<J.Identifier>();

        private ReplaceOptionalIsPresentWithIfPresentVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.collectLambdaAccessibleVariables(cu, ctx);
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J visitIf(J.If _if, ExecutionContext ctx) {
            J.If before = _if;
            J.If after = (J.If)super.visitIf(_if, (Object)ctx);
            boolean updated = after != before;
            _if = after;
            if (!(_if.getIfCondition().getTree() instanceof J.MethodInvocation) || !OPTIONAL_IS_PRESENT.matches((MethodCall)((J.MethodInvocation)_if.getIfCondition().getTree()))) {
                return _if;
            }
            if (_if.getElsePart() != null) {
                return _if;
            }
            if (this.getCursor().getParentTreeCursor().getValue() instanceof J.If.Else) {
                return _if;
            }
            if (!(_if.getIfCondition().getTree() instanceof J.MethodInvocation) || !OPTIONAL_IS_PRESENT.matches((MethodCall)((J.MethodInvocation)_if.getIfCondition().getTree()))) {
                return _if;
            }
            J.Identifier optionalVariable = (J.Identifier)((J.MethodInvocation)_if.getIfCondition().getTree()).getSelect();
            if (optionalVariable == null || !this.isStatementLambdaConvertible(_if.getThenPart())) {
                return _if;
            }
            String methodSelector = optionalVariable.getSimpleName();
            Cursor nameScope = this.getCursor();
            if (updated) {
                nameScope = new Cursor(this.getCursor().getParentOrThrow(), (Object)after);
            }
            String uniqueLambdaParameterName = VariableNameUtils.generateVariableName((String)"obj", (Cursor)nameScope, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
            String template = String.format("%s.ifPresent(%s -> #{any()})", methodSelector, uniqueLambdaParameterName);
            J ifPresentMi = JavaTemplate.builder((String)template).contextSensitive().build().apply(this.getCursor(), _if.getCoordinates().replace(), new Object[]{_if.getThenPart()});
            J.Identifier lambdaParameterIdentifier = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)((J.Lambda)((J.MethodInvocation)ifPresentMi).getArguments().get(0)).getParameters().getParameters().get(0)).getVariables().get(0)).getName();
            this.lambdaAccessibleVariables.add(lambdaParameterIdentifier);
            return ReplaceMethodCallWithVariableVisitor.replace(ifPresentMi, ctx, lambdaParameterIdentifier, optionalVariable);
        }

        private boolean isStatementLambdaConvertible(Statement statement) {
            return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                public J.Identifier visitIdentifier(J.Identifier id, AtomicBoolean convertible) {
                    if (id.getType() == null || id.getFieldType() == null || id.getFieldType().getOwner() instanceof JavaType.Class) {
                        return id;
                    }
                    if (lambdaAccessibleVariables.stream().noneMatch(v -> id.getFieldType().equals((Object)v.getFieldType()) && v.getSimpleName().equals(id.getSimpleName()))) {
                        convertible.set(false);
                    }
                    return id;
                }

                public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, AtomicBoolean convertible) {
                    return classDecl;
                }

                public J.Lambda visitLambda(J.Lambda lambda, AtomicBoolean convertible) {
                    return lambda;
                }

                public J.Return visitReturn(J.Return _return, AtomicBoolean convertible) {
                    convertible.set(false);
                    return _return;
                }

                public J.Throw visitThrow(J.Throw thrown, AtomicBoolean convertible) {
                    convertible.set(false);
                    return thrown;
                }

                public J.Continue visitContinue(J.Continue continueStatement, AtomicBoolean convertible) {
                    convertible.set(false);
                    return continueStatement;
                }

                public J.Break visitBreak(J.Break breakStatement, AtomicBoolean convertible) {
                    convertible.set(false);
                    convertible.set(false);
                    return breakStatement;
                }

                public J.Block visitBlock(J.Block block, AtomicBoolean convertible) {
                    if (this.getCursor().getParentTreeCursor().getValue() instanceof J.NewClass) {
                        return block;
                    }
                    return super.visitBlock(block, (Object)convertible);
                }
            }.reduce((Tree)statement, (Object)new AtomicBoolean(true))).get();
        }

        private void collectLambdaAccessibleVariables(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit finalizeLocalVariablesCu = (J.CompilationUnit)new FinalizeLocalVariables().getVisitor().visit((Tree)cu, (Object)ctx);
            J.CompilationUnit finalizeMethodArgumentsCu = (J.CompilationUnit)new FinalizeMethodArguments().getVisitor().visit((Tree)cu, (Object)ctx);
            JavaIsoVisitor<List<J.Identifier>> finalVariablesCollector = new JavaIsoVisitor<List<J.Identifier>>(){

                public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, List<J.Identifier> identifiers) {
                    if (multiVariable.hasModifier(J.Modifier.Type.Final)) {
                        identifiers.addAll(multiVariable.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getName).collect(Collectors.toList()));
                    }
                    return super.visitVariableDeclarations(multiVariable, identifiers);
                }

                public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, List<J.Identifier> identifiers) {
                    identifiers.addAll(ReplaceOptionalIsPresentWithIfPresentVisitor.collectFields(classDecl));
                    return super.visitClassDeclaration(classDecl, identifiers);
                }
            };
            finalVariablesCollector.visit((Tree)finalizeLocalVariablesCu, this.lambdaAccessibleVariables);
            finalVariablesCollector.visit((Tree)finalizeMethodArgumentsCu, this.lambdaAccessibleVariables);
        }

        private static List<J.Identifier> collectFields(J.ClassDeclaration classDecl) {
            return classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).map(J.VariableDeclarations.NamedVariable::getName).collect(Collectors.toList());
        }
    }

    public static final class ReplaceMethodCallWithVariableVisitor
    extends JavaVisitor<ExecutionContext> {
        private final J.Identifier lambdaParameterIdentifier;
        private final J.Identifier methodSelector;

        static J replace(J subtree, ExecutionContext ctx, J.Identifier lambdaParameterIdentifier, J.Identifier methodSelector) {
            return (J)new ReplaceMethodCallWithVariableVisitor(lambdaParameterIdentifier, methodSelector).visitNonNull((Tree)subtree, ctx);
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            if (OPTIONAL_GET.matches((MethodCall)mi) && mi.getSelect() instanceof J.Identifier) {
                J.Identifier selectToBeReplaced = (J.Identifier)mi.getSelect();
                if (this.methodSelector.getSimpleName().equals(selectToBeReplaced.getSimpleName()) && this.methodSelector.getFieldType() != null && this.methodSelector.getFieldType().equals((Object)selectToBeReplaced.getFieldType())) {
                    return this.lambdaParameterIdentifier.withPrefix(method.getPrefix());
                }
            }
            return mi;
        }

        @Generated
        public ReplaceMethodCallWithVariableVisitor(J.Identifier lambdaParameterIdentifier, J.Identifier methodSelector) {
            this.lambdaParameterIdentifier = lambdaParameterIdentifier;
            this.methodSelector = methodSelector;
        }

        @Generated
        public J.Identifier getLambdaParameterIdentifier() {
            return this.lambdaParameterIdentifier;
        }

        @Generated
        public J.Identifier getMethodSelector() {
            return this.methodSelector;
        }

        @Generated
        public String toString() {
            return "ReplaceOptionalIsPresentWithIfPresent.ReplaceMethodCallWithVariableVisitor(lambdaParameterIdentifier=" + this.getLambdaParameterIdentifier() + ", methodSelector=" + this.getMethodSelector() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceMethodCallWithVariableVisitor)) {
                return false;
            }
            ReplaceMethodCallWithVariableVisitor other = (ReplaceMethodCallWithVariableVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.Identifier this$lambdaParameterIdentifier = this.getLambdaParameterIdentifier();
            J.Identifier other$lambdaParameterIdentifier = other.getLambdaParameterIdentifier();
            if (this$lambdaParameterIdentifier == null ? other$lambdaParameterIdentifier != null : !this$lambdaParameterIdentifier.equals(other$lambdaParameterIdentifier)) {
                return false;
            }
            J.Identifier this$methodSelector = this.getMethodSelector();
            J.Identifier other$methodSelector = other.getMethodSelector();
            return !(this$methodSelector == null ? other$methodSelector != null : !this$methodSelector.equals(other$methodSelector));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReplaceMethodCallWithVariableVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.Identifier $lambdaParameterIdentifier = this.getLambdaParameterIdentifier();
            result = result * 59 + ($lambdaParameterIdentifier == null ? 43 : $lambdaParameterIdentifier.hashCode());
            J.Identifier $methodSelector = this.getMethodSelector();
            result = result * 59 + ($methodSelector == null ? 43 : $methodSelector.hashCode());
            return result;
        }
    }
}

