/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.EmptyBlockVisitor;
import org.openrewrite.staticanalysis.RemoveUnneededBlock;
import org.openrewrite.staticanalysis.RemoveUnreachableCodeVisitor;

public class SimplifyConstantIfBranchExecution
extends Recipe {
    public String getDisplayName() {
        return "Simplify constant if branch execution";
    }

    public String getDescription() {
        return "Checks for if expressions that are always `true` or `false` and simplifies them.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SimplifyConstantIfBranchExecutionVisitor();
    }

    private static class SimplifyConstantIfBranchExecutionVisitor
    extends JavaVisitor<ExecutionContext> {
        private SimplifyConstantIfBranchExecutionVisitor() {
        }

        public J visitBlock(J.Block block, ExecutionContext ctx) {
            J.Block bl = (J.Block)super.visitBlock(block, (Object)ctx);
            if (bl != block) {
                bl = (J.Block)new RemoveUnneededBlock.RemoveUnneededBlockStatementVisitor().visitNonNull((Tree)bl, ctx, this.getCursor().getParentOrThrow());
                EmptyBlockStyle style = (EmptyBlockStyle)((JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getStyle(EmptyBlockStyle.class);
                if (style == null) {
                    style = Checkstyle.emptyBlock();
                }
                bl = (J.Block)new EmptyBlockVisitor(style).visitNonNull((Tree)bl, ctx, this.getCursor().getParentOrThrow());
            }
            return bl;
        }

        private static <E extends Expression> E cleanupBooleanExpression(E expression, Cursor c, ExecutionContext ctx) {
            Expression ex1 = (Expression)new UnnecessaryParenthesesVisitor().visitNonNull(expression, (Object)ctx, c.getParentOrThrow());
            if (expression == (ex1 = (Expression)new SimplifyBooleanExpressionVisitor().visitNonNull((Tree)ex1, (Object)ctx, c.getParentTreeCursor())) || J.Literal.isLiteralValue((Expression)ex1, (Object)Boolean.FALSE) || J.Literal.isLiteralValue((Expression)ex1, (Object)Boolean.TRUE)) {
                return (E)ex1;
            }
            return (E)SimplifyConstantIfBranchExecutionVisitor.cleanupBooleanExpression(ex1, c, ctx);
        }

        public J visitIf(J.If if_, ExecutionContext ctx) {
            J.If if__;
            J.If ifBeforeCleanup = if__ = (J.If)super.visitIf(if_, (Object)ctx);
            J.ControlParentheses cp = SimplifyConstantIfBranchExecutionVisitor.cleanupBooleanExpression(if__.getIfCondition(), this.getCursor(), ctx);
            if__ = if__.withIfCondition(cp);
            Optional<Boolean> compileTimeConstantBoolean = J.Literal.isLiteralValue((Expression)((Expression)cp.getTree()), (Object)Boolean.TRUE) ? Optional.of(true) : (J.Literal.isLiteralValue((Expression)((Expression)cp.getTree()), (Object)Boolean.FALSE) ? Optional.of(false) : Optional.empty());
            if (!compileTimeConstantBoolean.isPresent()) {
                return ifBeforeCleanup;
            }
            if (compileTimeConstantBoolean.get().booleanValue()) {
                Statement s = (Statement)if__.getThenPart().withPrefix(if__.getPrefix());
                this.doAfterVisit((TreeVisitor)new RemoveUnreachableCodeVisitor());
                return this.maybeAutoFormat((J)if__, (J)s, ctx);
            }
            if (if__.getElsePart() != null) {
                Statement s = (Statement)if__.getElsePart().getBody().withPrefix(if__.getPrefix());
                this.doAfterVisit((TreeVisitor)new RemoveUnreachableCodeVisitor());
                return this.maybeAutoFormat((J)if__, (J)s, ctx);
            }
            return J.Block.createEmptyBlock();
        }

        public J visitTernary(J.Ternary ternary, ExecutionContext ctx) {
            J.Ternary j = (J.Ternary)super.visitTernary(ternary, (Object)ctx);
            return SimplifyConstantIfBranchExecutionVisitor.cleanupBooleanExpression(j, this.getCursor(), ctx);
        }
    }
}

