/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class RemoveExtraSemicolons
extends Recipe {
    public String getDisplayName() {
        return "Remove extra semicolons";
    }

    public String getDescription() {
        return "Optional semicolons at the end of try-with-resources are also removed.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-S1116", "RSPEC-S2959"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                Iterator iterator = block.getStatements().iterator();
                ArrayList<Statement> result = new ArrayList<Statement>();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    if (statement instanceof J.Empty) {
                        RemoveExtraSemicolons.this.nextNonEmptyAggregatedWithComments(statement, iterator).ifPresent(nextLine -> {
                            String whitespace = statement.getPrefix().getWhitespace();
                            if (!whitespace.contains("\n") && nextLine.getComments().isEmpty()) {
                                result.add((Statement)nextLine);
                            } else {
                                Space updatedPrefix = nextLine.getPrefix().withWhitespace(whitespace);
                                result.add((Statement)nextLine.withPrefix(updatedPrefix));
                            }
                        });
                        continue;
                    }
                    result.add(statement);
                }
                return super.visitBlock(block.withStatements(result), (Object)ctx);
            }

            public J.Try.Resource visitTryResource(J.Try.Resource tr, ExecutionContext ctx) {
                J.Try _try = (J.Try)this.getCursor().dropParentUntil(J.Try.class::isInstance).getValue();
                if (_try.getResources().isEmpty() || _try.getResources().get(_try.getResources().size() - 1) != tr || !((J.Try.Resource)_try.getResources().get(_try.getResources().size() - 1)).isTerminatedWithSemicolon()) {
                    return tr;
                }
                return tr.withTerminatedWithSemicolon(false);
            }

            public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enums, ExecutionContext ctx) {
                J.EnumValueSet e = super.visitEnumValueSet(enums, (Object)ctx);
                if (((J.Block)this.getCursor().firstEnclosing(J.Block.class)).getStatements().size() == 1) {
                    e = e.withTerminatedWithSemicolon(false);
                }
                return e;
            }
        };
    }

    private Optional<Statement> nextNonEmptyAggregatedWithComments(Statement current, Iterator<Statement> iterator) {
        ArrayList comments = new ArrayList(current.getComments());
        while (iterator.hasNext()) {
            Statement statement = iterator.next();
            comments.addAll(statement.getComments());
            if (statement instanceof J.Empty) continue;
            return Optional.of((Statement)statement.withComments(comments));
        }
        return Optional.empty();
    }
}

