/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceRedundantFormatWithPrintf
extends Recipe {
    private static final MethodMatcher STRING_FORMAT_MATCHER_LOCALE = new MethodMatcher("java.lang.String format(java.util.Locale, java.lang.String, java.lang.Object[])");
    private static final MethodMatcher STRING_FORMAT_MATCHER_NO_LOCALE = new MethodMatcher("java.lang.String format(java.lang.String, java.lang.Object[])");
    private static final MethodMatcher PRINTSTREAM_PRINT_MATCHER = new MethodMatcher("java.io.PrintStream print(java.lang.String)", true);
    private static final MethodMatcher PRINTSTREAM_PRINTLN_MATCHER = new MethodMatcher("java.io.PrintStream println(java.lang.String)", true);

    public String getDisplayName() {
        return "Replace redundant String format invocations that are wrapped with PrintStream operations";
    }

    public String getDescription() {
        return "Replaces `PrintStream.print(String.format(format, ...args))` with `PrintStream.printf(format, ...args)` (and for `println`, appends a newline to the format string).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_FORMAT_MATCHER_LOCALE), new UsesMethod(STRING_FORMAT_MATCHER_NO_LOCALE)}), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(PRINTSTREAM_PRINT_MATCHER), new UsesMethod(PRINTSTREAM_PRINTLN_MATCHER)})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                List printfArgs;
                boolean hasLocaleArg;
                boolean needsNewline;
                method = super.visitMethodInvocation(method, (Object)ctx);
                if (PRINTSTREAM_PRINTLN_MATCHER.matches((MethodCall)method)) {
                    needsNewline = true;
                } else if (PRINTSTREAM_PRINT_MATCHER.matches((MethodCall)method)) {
                    needsNewline = false;
                } else {
                    return method;
                }
                Expression arg = (Expression)method.getArguments().get(0);
                if (!(arg instanceof J.MethodInvocation)) {
                    return method;
                }
                J.MethodInvocation innerMethodInvocation = (J.MethodInvocation)arg;
                if (STRING_FORMAT_MATCHER_NO_LOCALE.matches((MethodCall)innerMethodInvocation)) {
                    hasLocaleArg = false;
                } else if (STRING_FORMAT_MATCHER_LOCALE.matches((MethodCall)innerMethodInvocation)) {
                    hasLocaleArg = true;
                } else {
                    return method;
                }
                List originalFormatArgs = innerMethodInvocation.getArguments();
                if (needsNewline) {
                    Expression formatStringExpression = (Expression)originalFormatArgs.get(hasLocaleArg ? 1 : 0);
                    if (!(formatStringExpression instanceof J.Literal)) {
                        return method;
                    }
                    J.Literal formatStringLiteral = (J.Literal)formatStringExpression;
                    Object formatStringValue = formatStringLiteral.getValue();
                    if (!(formatStringValue instanceof String)) {
                        return method;
                    }
                    if ((formatStringLiteral = ReplaceRedundantFormatWithPrintf.appendToStringLiteral(formatStringLiteral)) == null) {
                        return method;
                    }
                    List formatStringArgs = originalFormatArgs.subList(hasLocaleArg ? 2 : 1, originalFormatArgs.size());
                    printfArgs = ListUtils.concat((Object)formatStringLiteral, formatStringArgs);
                    if (hasLocaleArg) {
                        printfArgs = ListUtils.concat((Object)((Expression)originalFormatArgs.get(0)), (List)printfArgs);
                    }
                } else {
                    printfArgs = originalFormatArgs;
                }
                StringBuilder code = new StringBuilder();
                code.append("printf(");
                for (int i = 0; i < originalFormatArgs.size(); ++i) {
                    JavaType argType = ((Expression)originalFormatArgs.get(i)).getType();
                    if (i != 0) {
                        code.append(", ");
                    }
                    code.append("#{any(");
                    if (argType instanceof JavaType.GenericTypeVariable) {
                        List bounds = ((JavaType.GenericTypeVariable)argType).getBounds();
                        if (bounds.isEmpty()) {
                            code.append("Object");
                        } else {
                            code.append(bounds.get(0));
                        }
                    } else if (argType instanceof JavaType.Parameterized) {
                        code.append(((JavaType.Parameterized)argType).getType());
                    } else {
                        code.append(argType);
                    }
                    code.append(")}");
                }
                code.append(")");
                JavaTemplate template = JavaTemplate.builder((String)code.toString()).contextSensitive().build();
                return (J.MethodInvocation)this.maybeAutoFormat((J)method, (J)((J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replaceMethod(), printfArgs.toArray())), ctx);
            }
        });
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.Literal appendToStringLiteral(J.Literal literal) {
        if (literal.getType() != JavaType.Primitive.String) {
            return null;
        }
        Object value = literal.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String stringValue = (String)value;
        String newStringValue = stringValue + "%n";
        String valueSource = literal.getValueSource();
        if (valueSource != null && valueSource.startsWith("\"\"\"") && valueSource.endsWith("\"\"\"")) {
            return literal.withValueSource(valueSource.substring(0, valueSource.length() - 3) + "%n\"\"\"").withValue((Object)newStringValue);
        }
        if (valueSource != null && valueSource.startsWith("\"") && valueSource.endsWith("\"")) {
            return literal.withValueSource(valueSource.substring(0, valueSource.length() - 1) + "%n\"").withValue((Object)newStringValue);
        }
        return null;
    }
}

