/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.customRecipes;

import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelJavaVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class LiteralRegexpConverterRecipe
extends Recipe {
    @Option(example="TODO Provide a usage example for the docs", displayName="Literal regexp name", description="Regexp for matching a literal.")
    public String regexp;
    @Option(example="TODO Provide a usage example for the docs", displayName="Replacement to use", description="Replacement to use.")
    public String replacement;

    public String getDisplayName() {
        return "Replaces a literal matching an expression";
    }

    public String getDescription() {
        return "Replaces literal, groups from regexp can be used as ${0}, ${1}, ...";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelJavaVisitor(){

            @Override
            protected J.Literal doVisitLiteral(J.Literal literal, ExecutionContext ctx) {
                Matcher m;
                J.Literal l = super.doVisitLiteral(literal, ctx);
                if (TypeUtils.isString((JavaType)literal.getType()) && literal.getValue() != null && (m = this.getPattern(LiteralRegexpConverterRecipe.this.regexp.trim()).matcher((String)literal.getValue())).matches()) {
                    String tmp2;
                    String tmp = LiteralRegexpConverterRecipe.this.replacement;
                    for (int i = 1; i <= 100 && tmp.contains("${" + i + "}") && !tmp.equals(tmp2 = tmp.replaceAll("\\$\\{" + i + "}", m.group(i))); ++i) {
                        tmp = tmp2;
                    }
                    return RecipesUtil.createStringLiteral(tmp);
                }
                return l;
            }
        });
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiteralRegexpConverterRecipe)) {
            return false;
        }
        LiteralRegexpConverterRecipe other = (LiteralRegexpConverterRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$regexp = this.regexp;
        String other$regexp = other.regexp;
        if (this$regexp == null ? other$regexp != null : !this$regexp.equals(other$regexp)) {
            return false;
        }
        String this$replacement = this.replacement;
        String other$replacement = other.replacement;
        return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof LiteralRegexpConverterRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regexp = this.regexp;
        result = result * 59 + ($regexp == null ? 43 : $regexp.hashCode());
        String $replacement = this.replacement;
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        return result;
    }

    @Generated
    public LiteralRegexpConverterRecipe() {
    }

    @Generated
    public LiteralRegexpConverterRecipe(String regexp, String replacement) {
        this.regexp = regexp;
        this.replacement = replacement;
    }
}

