/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class NewClassToStaticFactory
extends Recipe {
    public String getDisplayName() {
        return "Transform 'new' expressions to static factory methods";
    }

    public String getDescription() {
        return "Transforms 'new' expression for client config related objects to the equivalent .create() expression in V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NewClassToStaticFactoryVisitor();
    }

    private static class NewClassToStaticFactoryVisitor
    extends JavaVisitor<ExecutionContext> {
        private NewClassToStaticFactoryVisitor() {
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            if (!((newClass = (J.NewClass)super.visitNewClass(newClass, (Object)executionContext).cast()).getType() instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            JavaType.FullyQualified classType = (JavaType.FullyQualified)newClass.getType();
            if (!SdkTypeUtils.isEligibleToConvertToStaticFactory(classType)) {
                return newClass;
            }
            String fullyQualifiedName = classType.getFullyQualifiedName();
            int numOfParams = SdkTypeUtils.V2_CORE_CLASSES_WITH_STATIC_FACTORY.get(fullyQualifiedName);
            switch (numOfParams) {
                case 0: {
                    return JavaTemplate.builder((String)(classType.getClassName() + ".create()")).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[0]);
                }
                case 1: {
                    return JavaTemplate.builder((String)String.format("%s.create(#{any()})", classType.getClassName())).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
                }
                case 2: {
                    return JavaTemplate.builder((String)String.format("%s.create(#{any()}, #{any()})", classType.getClassName())).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0), newClass.getArguments().get(1)});
                }
                case 3: {
                    return JavaTemplate.builder((String)String.format("%s.create(#{any()}, #{any()}, #{any()})", classType.getClassName())).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0), newClass.getArguments().get(1), newClass.getArguments().get(2)});
                }
            }
            throw new UnsupportedOperationException("Unsupported number of parameters: " + numOfParams);
        }
    }
}

