/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class S3PutObjectRequestToV2
extends Recipe {
    private static final MethodMatcher PUT_OBJECT_STREAM_METADATA = S3TransformUtils.v2S3MethodMatcher(String.format("putObject(String, String, java.io.InputStream, %sHeadObjectResponse)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher PUT_OBJ_WITH_REQUEST = S3TransformUtils.v2S3MethodMatcher(String.format("putObject(%sPutObjectRequest)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher UPLOAD_WITH_REQUEST = S3TransformUtils.v2TmMethodMatcher(String.format("upload(%sPutObjectRequest)", "software.amazon.awssdk.services.s3.model."));

    public String getDisplayName() {
        return "V1 S3 PutObjectRequest, AmazonS3.putObject(PutObjectRequest), and TransferManager.upload(PutObjectRequest) to V2";
    }

    public String getDescription() {
        return "Transform V1 S3 PutObjectRequest to V2, as well as methods that take it as an argument.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaVisitor<ExecutionContext> {
        private final Queue<Expression> payloadQueue = new ArrayDeque<Expression>();
        private final Queue<String> metadataNameQueue = new ArrayDeque<String>();
        private final Map<String, Expression> requestToPayloadMap = new HashMap<String, Expression>();
        private final Map<String, String> requestToMetadataNamesMap = new HashMap<String, String>();
        private final Map<String, Map<String, Expression>> metadataMap = new HashMap<String, Map<String, Expression>>();

        private Visitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (S3TransformUtils.isObjectMetadataSetter(method)) {
                return this.saveMetadataValueAndRemoveStatement(method);
            }
            if (S3TransformUtils.isPutObjectRequestBuilderSetter(method)) {
                if (S3TransformUtils.isRequestMetadataSetter(method)) {
                    method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                    return this.transformWithMetadata(method);
                }
                if (S3TransformUtils.isPayloadSetter(method)) {
                    return this.transformRequestBuilderPayloadSetter(method);
                }
                if (S3TransformUtils.isRequestPayerSetter(method)) {
                    return this.transformWithRequesterPays(method);
                }
                if (S3TransformUtils.isUnsupportedPutObjectRequestSetter(method)) {
                    method = S3TransformUtils.addCommentForUnsupportedPutObjectRequestSetter(method);
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
            }
            if (S3TransformUtils.isPutObjectRequestSetter(method)) {
                if (S3TransformUtils.isRequestMetadataSetter(method)) {
                    return this.convertSetMetadataToBuilder(method);
                }
                if (S3TransformUtils.isPayloadSetter(method)) {
                    return this.transformRequestPayloadSetter(method);
                }
            }
            if (PUT_OBJECT_STREAM_METADATA.matches((MethodCall)method)) {
                method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                return this.transformPutObjectWithStreamAndMetadata(method);
            }
            if (PUT_OBJ_WITH_REQUEST.matches((MethodCall)method)) {
                method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                return this.transformPutObjectWithRequest(method);
            }
            if (UPLOAD_WITH_REQUEST.matches((MethodCall)method)) {
                method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                return this.transformUploadWithRequest(method);
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        private J.MethodInvocation transformRequestBuilderPayloadSetter(J.MethodInvocation method) {
            Expression payload = (Expression)method.getArguments().get(0);
            String variableName = this.retrieveVariableNameIfRequestPojoIsAssigned();
            if (variableName != null) {
                this.requestToPayloadMap.put(variableName, payload);
            } else {
                this.payloadQueue.add(payload);
            }
            return (J.MethodInvocation)method.getSelect();
        }

        private J.MethodInvocation transformRequestPayloadSetter(J.MethodInvocation method) {
            J.Identifier requestPojo = (J.Identifier)method.getSelect();
            String variableName = requestPojo.getSimpleName();
            Expression payload = (Expression)method.getArguments().get(0);
            this.requestToPayloadMap.put(variableName, payload);
            return null;
        }

        private String retrieveVariableNameIfRequestPojoIsAssigned() {
            J parent = (J)this.getCursor().dropParentUntil(p -> p instanceof J.VariableDeclarations.NamedVariable || p instanceof J.Block).getValue();
            if (parent instanceof J.VariableDeclarations.NamedVariable) {
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)parent;
                return namedVariable.getSimpleName();
            }
            return null;
        }

        private J.MethodInvocation transformPutObjectWithRequest(J.MethodInvocation method) {
            Expression payload = this.retrieveRequestPayload(method);
            if (payload == null) {
                method = this.addEmptyRequestBodyToPutObject(method);
            } else if (SdkTypeUtils.isFileType(payload.getType())) {
                method = this.addFileToPutObject(method, payload);
            } else if (SdkTypeUtils.isInputStreamType(payload.getType())) {
                method = this.addInputStreamToPutObject(method, payload);
            }
            this.addRequestBodyImport();
            return method;
        }

        private Expression retrieveRequestPayload(J.MethodInvocation method) {
            Expression payload;
            Expression requestPojo = (Expression)method.getArguments().get(0);
            if (requestPojo instanceof J.Identifier) {
                J.Identifier pojo = (J.Identifier)requestPojo;
                payload = this.requestToPayloadMap.get(pojo.getSimpleName());
            } else {
                payload = this.payloadQueue.poll();
            }
            return payload;
        }

        private J.MethodInvocation transformUploadWithRequest(J.MethodInvocation method) {
            Expression payload = this.retrieveRequestPayload(method);
            if (payload == null) {
                method = this.addEmptyAsyncRequestBodyToUpload(method);
            } else if (SdkTypeUtils.isFileType(payload.getType())) {
                method = this.addFileAndChangeMethodToUploadFile(method, payload);
            } else if (SdkTypeUtils.isInputStreamType(payload.getType())) {
                method = this.addInputStreamToUpload(method, payload);
            }
            return method;
        }

        private J.MethodInvocation addEmptyAsyncRequestBodyToUpload(J.MethodInvocation method) {
            String v2Method = "UploadRequest.builder().putObjectRequest(#{any()}).requestBody(AsyncRequestBody.empty()).build()";
            this.addTmImport("UploadRequest");
            this.addAsyncRequestBodyImport();
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation addEmptyRequestBodyToPutObject(J.MethodInvocation method) {
            String v2Method = "#{any()}, RequestBody.empty()";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation addFileAndChangeMethodToUploadFile(J.MethodInvocation method, Expression file) {
            String v2Method = "#{any()}.uploadFile(UploadFileRequest.builder().putObjectRequest(#{any()}).source(#{any()}).build())";
            this.addTmImport("UploadFileRequest");
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), file});
        }

        private J.MethodInvocation addInputStreamToUpload(J.MethodInvocation method, Expression inputStream) {
            this.addTmImport("UploadRequest");
            this.addAsyncRequestBodyImport();
            StringBuilder sb = new StringBuilder("UploadRequest.builder().putObjectRequest(#{any()}).requestBody(AsyncRequestBody.fromInputStream(#{any()}, ");
            String metadataName = this.getMetadataForRequest(method);
            Expression contentLength = metadataName == null ? null : this.retrieveContentLengthForMetadataIfSet(metadataName);
            Object[] params = new Expression[]{(Expression)method.getArguments().get(0), inputStream};
            if (contentLength == null) {
                sb.append("-1L");
            } else {
                sb.append("#{any()}");
                params = Arrays.copyOf(params, 3);
                params[2] = contentLength;
            }
            sb.append(", newExecutorServiceVariableToDefine)).build()");
            String comment = "When using InputStream to upload with TransferManager, you must specify Content-Length and ExecutorService.";
            return (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), params).withComments(S3TransformUtils.createComments(comment));
        }

        private J.MethodInvocation addFileToPutObject(J.MethodInvocation method, Expression file) {
            String v2Method = "#{any()}, RequestBody.fromFile(#{any()})";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), file});
        }

        private J.MethodInvocation addInputStreamToPutObject(J.MethodInvocation method, Expression inputStream) {
            String metadataName = this.getMetadataForRequest(method);
            Expression contentLen = metadataName == null ? null : this.retrieveContentLengthForMetadataIfSet(metadataName);
            if (contentLen == null) {
                String v2Method = "#{any()}, RequestBody.fromContentProvider(() -> #{any()}, \"application/octet-stream\")";
                return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), inputStream}).withComments(S3TransformUtils.inputStreamBufferingWarningComment());
            }
            String v2Method = "#{any()}, RequestBody.fromInputStream(#{any()}, #{any()})";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), inputStream, contentLen});
        }

        private J.MethodInvocation transformPutObjectWithStreamAndMetadata(J.MethodInvocation method) {
            this.addRequestBodyImport();
            this.addS3Import("PutObjectRequest");
            Expression metadata = (Expression)method.getArguments().get(3);
            String metadataName = null;
            if (metadata instanceof J.Identifier) {
                metadataName = ((J.Identifier)metadata).getSimpleName();
            }
            StringBuilder sb = new StringBuilder("PutObjectRequest.builder().bucket(#{any()}).key(#{any()})");
            Expression contentLen = null;
            if (metadataName != null) {
                S3TransformUtils.addMetadataFields(sb, metadataName, this.metadataMap);
                contentLen = this.retrieveContentLengthForMetadataIfSet(metadataName);
            }
            Object[] params = new Expression[]{(Expression)method.getArguments().get(0), (Expression)method.getArguments().get(1), (Expression)method.getArguments().get(2)};
            if (contentLen == null) {
                sb.append(".build(), RequestBody.fromContentProvider(() -> #{any()}, \"application/octet-stream\")");
                return (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), params).withComments(S3TransformUtils.inputStreamBufferingWarningComment());
            }
            sb.append(".build(), RequestBody.fromInputStream(#{any()}, #{any()})");
            params = Arrays.copyOf(params, 4);
            params[3] = contentLen;
            return (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), params);
        }

        private J.MethodInvocation transformWithMetadata(J.MethodInvocation method) {
            String metadataName = S3TransformUtils.getArgumentName(method);
            String requestName = this.retrieveVariableNameIfRequestPojoIsAssigned();
            if (requestName == null) {
                this.metadataNameQueue.add(metadataName);
            } else {
                this.requestToMetadataNamesMap.put(requestName, metadataName);
            }
            Map<String, Expression> map = this.metadataMap.get(metadataName);
            if (map == null) {
                return (J.MethodInvocation)method.getSelect();
            }
            StringBuilder sb = new StringBuilder("#{any()}");
            S3TransformUtils.addMetadataFields(sb, metadataName, this.metadataMap);
            return (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
        }

        private J convertSetMetadataToBuilder(J.MethodInvocation method) {
            String requestName = S3TransformUtils.getSelectName(method);
            String metadataName = S3TransformUtils.getArgumentName(method);
            this.requestToMetadataNamesMap.put(requestName, metadataName);
            Map<String, Expression> map = this.metadataMap.get(metadataName);
            if (map == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder("#{any()} = #{any()}.toBuilder()");
            S3TransformUtils.addMetadataFields(sb, metadataName, this.metadataMap);
            sb.append(".build()");
            return JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getSelect()});
        }

        private String getMetadataForRequest(J.MethodInvocation method) {
            Expression arg = (Expression)method.getArguments().get(0);
            if (arg instanceof J.Identifier) {
                String requestName = ((J.Identifier)arg).getSimpleName();
                return this.requestToMetadataNamesMap.get(requestName);
            }
            return this.metadataNameQueue.poll();
        }

        private Expression retrieveContentLengthForMetadataIfSet(String metadataName) {
            Map<String, Expression> map = this.metadataMap.get(metadataName);
            if (map == null) {
                return null;
            }
            return map.get("contentLength");
        }

        private J.MethodInvocation saveMetadataValueAndRemoveStatement(J.MethodInvocation method) {
            J.Identifier metadataPojo = (J.Identifier)method.getSelect();
            String variableName = metadataPojo.getSimpleName();
            String methodName = method.getSimpleName();
            if (!S3TransformUtils.SUPPORTED_METADATA_TRANSFORMS.contains(methodName)) {
                String comment = String.format("Transform for ObjectMetadata setter - %s - is not supported, please manually migrate the code by setting it on the v2 request/response object.", methodName);
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            Expression value = (Expression)method.getArguments().get(0);
            Map<String, Expression> map = this.metadataMap.get(variableName);
            if (map == null) {
                map = new HashMap<String, Expression>();
            }
            map.put(methodName, value);
            this.metadataMap.put(variableName, map);
            return null;
        }

        private J.MethodInvocation transformWithRequesterPays(J.MethodInvocation method) {
            Expression expression = (Expression)method.getArguments().get(0);
            if (expression instanceof J.Literal) {
                J.Literal literal = (J.Literal)expression;
                if (Boolean.TRUE.equals(literal.getValue())) {
                    this.addS3Import("RequestPayer");
                } else {
                    return (J.MethodInvocation)method.getSelect();
                }
            }
            return (J.MethodInvocation)JavaTemplate.builder((String)"RequestPayer.REQUESTER").build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[0]);
        }

        private void addRequestBodyImport() {
            String fqcn = "software.amazon.awssdk.core.sync.RequestBody";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addAsyncRequestBodyImport() {
            String fqcn = "software.amazon.awssdk.core.async.AsyncRequestBody";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addS3Import(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addTmImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.transfer.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }
    }
}

