/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class MapRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MapRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Map` instances.\n[Source](https://error-prone.picnic.tech/refasterrules/MapRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new MapGetOrNullRecipe(), new MapGetOrDefaultRecipe(), new MapIsEmptyRecipe(), new MapSizeRecipe(), new MapContainsKeyRecipe(), new MapContainsValueRecipe(), new MapKeyStreamRecipe(), new MapValueStreamRecipe()});
    }

    @NullMarked
    public static class MapGetOrNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapGetOrNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class MapGetOrNull<K, V, T> {\n    \n    @BeforeTemplate\n    @Nullable\n    V before(Map<K, V> map, T key) {\n        return map.getOrDefault(key, null);\n    }\n    \n    @AfterTemplate\n    @Nullable\n    V after(Map<K, V> map, T key) {\n        return map.get(key);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.getOrDefault(#{key:any(T)}, null)").bindType("V").genericTypes(new String[]{"K", "V", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.get(#{key:any(T)})").bindType("V").genericTypes(new String[]{"K", "V", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Map getOrDefault(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapGetOrDefaultRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapGetOrDefault`";
        }

        public String getDescription() {
            return "Prefer `Map#getOrDefault(Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Objects.requireNonNullElse(#{map:any(java.util.Map<K, V>)}.get(#{key:any(T)}), #{defaultValue:any(V)})").bindType("V").genericTypes(new String[]{"K", "V", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        this.maybeRemoveImport("java.util.Objects.requireNonNullElse");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.getOrDefault(#{key:any(T)}, #{defaultValue:any(V)})").bindType("V").genericTypes(new String[]{"K", "V", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Map get(..)", true), new UsesMethod("java.util.Objects requireNonNullElse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `Map#isEmpty()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.keySet().isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.values().isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.entrySet().isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Collection isEmpty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map entrySet(..)", true), new UsesMethod("java.util.Map keySet(..)", true), new UsesMethod("java.util.Map values(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapSize`";
        }

        public String getDescription() {
            return "Prefer `Map#size()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.keySet().size()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.size()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.values().size()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.size()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.entrySet().size()").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.size()").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Collection size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Map entrySet(..)", true), new UsesMethod("java.util.Map keySet(..)", true), new UsesMethod("java.util.Map values(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapContainsKeyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapContainsKey`";
        }

        public String getDescription() {
            return "Prefer `Map#containsKey(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.keySet().contains(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.containsKey(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Map keySet(..)", true), new UsesMethod("java.util.Set contains(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapContainsValueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapContainsValue`";
        }

        public String getDescription() {
            return "Prefer `Map#containsValue(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.values().contains(#{value:any(T)})").genericTypes(new String[]{"K", "V", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.containsValue(#{value:any(T)})").genericTypes(new String[]{"K", "V", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("java.util.Collection contains(..)", true), new UsesMethod("java.util.Map values(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapKeyStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapKeyStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily use `Map#entrySet()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.entrySet().stream().map(java.util.Map.Entry::getKey)").bindType("java.util.stream.Stream<K>").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.keySet().stream()").bindType("java.util.stream.Stream<K>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Map entrySet(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapValueStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MapRules.MapValueStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily use `Map#entrySet()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.entrySet().stream().map(java.util.Map.Entry::getValue)").bindType("java.util.stream.Stream<V>").genericTypes(new String[]{"K", "V"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{map:any(java.util.Map<K, V>)}.values().stream()").bindType("java.util.stream.Stream<V>").genericTypes(new String[]{"K", "V"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Map entrySet(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

