/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.revwalk.filter;

import java.io.IOException;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.errors.MissingObjectException;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.revwalk.filter.RevFilter;
import org.openrewrite.shaded.jgit.util.RawCharSequence;
import org.openrewrite.shaded.jgit.util.RawSubStringPattern;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected SubStringRevFilter(String patternText) {
        this.pattern = new RawSubStringPattern(patternText);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pattern.match(this.text(cmit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(\"" + this.pattern.pattern() + "\")";
    }
}

