/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class TravisBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildNumber;
    private final String buildId;
    private final String buildUrl;
    private final String host;
    private final String job;
    private final String branch;
    private final String commit;
    private final String repoSlug;
    private final String tag;

    public static TravisBuildEnvironment build(UnaryOperator<String> environment) {
        return new TravisBuildEnvironment(Tree.randomId(), (String)environment.apply("TRAVIS_BUILD_NUMBER"), (String)environment.apply("TRAVIS_BUILD_ID"), (String)environment.apply("TRAVIS_BUILD_WEB_URL"), OperatingSystemProvenance.hostname(), (String)environment.apply("TRAVIS_REPO_SLUG"), (String)environment.apply("TRAVIS_BRANCH"), (String)environment.apply("TRAVIS_COMMIT"), (String)environment.apply("TRAVIS_REPO_SLUG"), (String)environment.apply("TRAVIS_TAG"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        throw new IncompleteGitConfigException();
    }

    public TravisBuildEnvironment(UUID id, String buildNumber, String buildId, String buildUrl, String host, String job, String branch, String commit, String repoSlug, String tag) {
        this.id = id;
        this.buildNumber = buildNumber;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.host = host;
        this.job = job;
        this.branch = branch;
        this.commit = commit;
        this.repoSlug = repoSlug;
        this.tag = tag;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getRepoSlug() {
        return this.repoSlug;
    }

    public String getTag() {
        return this.tag;
    }

    @NonNull
    public String toString() {
        return "TravisBuildEnvironment(id=" + this.getId() + ", buildNumber=" + this.getBuildNumber() + ", buildId=" + this.getBuildId() + ", buildUrl=" + this.getBuildUrl() + ", host=" + this.getHost() + ", job=" + this.getJob() + ", branch=" + this.getBranch() + ", commit=" + this.getCommit() + ", repoSlug=" + this.getRepoSlug() + ", tag=" + this.getTag() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TravisBuildEnvironment)) {
            return false;
        }
        TravisBuildEnvironment other = (TravisBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$commit = this.getCommit();
        String other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        String this$repoSlug = this.getRepoSlug();
        String other$repoSlug = other.getRepoSlug();
        if (this$repoSlug == null ? other$repoSlug != null : !this$repoSlug.equals(other$repoSlug)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        String $repoSlug = this.getRepoSlug();
        result = result * 59 + ($repoSlug == null ? 43 : $repoSlug.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @NonNull
    public TravisBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new TravisBuildEnvironment(id, this.buildNumber, this.buildId, this.buildUrl, this.host, this.job, this.branch, this.commit, this.repoSlug, this.tag);
    }
}

