/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.nio.file.Paths;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.remote.LocalRemoteArtifactCache;
import org.openrewrite.remote.RemoteArtifactCache;

public class RemoteExecutionContextView
extends DelegatingExecutionContext {
    private static final RemoteArtifactCache DEFAULT_ARTIFACT_CACHE = new LocalRemoteArtifactCache(Paths.get(System.getProperty("user.home") + "/.rewrite/remote", new String[0]));
    private static final String REMOTE_ARTIFACT_CACHE = "org.openrewrite.remote.artifactCache";

    private RemoteExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static RemoteExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof RemoteExecutionContextView) {
            return (RemoteExecutionContextView)ctx;
        }
        return new RemoteExecutionContextView(ctx);
    }

    public RemoteExecutionContextView setArtifactCache(RemoteArtifactCache artifactCache) {
        this.putMessage(REMOTE_ARTIFACT_CACHE, artifactCache);
        return this;
    }

    public RemoteArtifactCache getArtifactCache() {
        return this.getMessage(REMOTE_ARTIFACT_CACHE, DEFAULT_ARTIFACT_CACHE);
    }
}

