/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;

public class InMemoryExecutionContext
implements ExecutionContext,
Cloneable {
    private volatile @Nullable Map<String, Object> messages;
    private final Consumer<Throwable> onError;
    private final BiConsumer<Throwable, ExecutionContext> onTimeout;

    public InMemoryExecutionContext() {
        this(t -> {});
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError) {
        this(onError, Duration.ofHours(2L));
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError, Duration runTimeout) {
        this(onError, runTimeout, (throwable, ctx) -> {});
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError, Duration runTimeout, BiConsumer<Throwable, ExecutionContext> onTimeout) {
        this.onError = onError;
        this.onTimeout = onTimeout;
        this.putMessage("org.openrewrite.runTimeout", runTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, @Nullable Object> getMessages() {
        if (this.messages == null) {
            InMemoryExecutionContext inMemoryExecutionContext = this;
            synchronized (inMemoryExecutionContext) {
                if (this.messages == null) {
                    this.messages = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.messages;
    }

    @Override
    public void putMessage(String key, @Nullable Object value) {
        if (value == null) {
            if (this.messages != null) {
                this.getMessages().remove(key);
            }
        } else {
            this.getMessages().put(key, value);
        }
    }

    @Override
    public <T> @Nullable T getMessage(String key) {
        return (T)this.getMessages().get(key);
    }

    @Override
    public <T> @Nullable T pollMessage(String key) {
        return (T)this.getMessages().remove(key);
    }

    @Override
    public Consumer<Throwable> getOnError() {
        return this.onError;
    }

    @Override
    public BiConsumer<Throwable, ExecutionContext> getOnTimeout() {
        return this.onTimeout;
    }

    public InMemoryExecutionContext clone() {
        InMemoryExecutionContext clone = new InMemoryExecutionContext();
        clone.messages = new ConcurrentHashMap<String, Object>(this.getMessages());
        clone.messages.computeIfPresent("org.openrewrite.dataTables", (key, dt) -> new ConcurrentHashMap((Map)dt));
        return clone;
    }
}

