/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.TreeVisitorAdapterClassLoader;

public class TreeVisitorAdapter {
    private static final Integer classCreationLock = 1;
    private static final Map<ClassLoader, TreeVisitorAdapterClassLoader> classLoaders = new IdentityHashMap<ClassLoader, TreeVisitorAdapterClassLoader>();

    private TreeVisitorAdapter() {
    }

    public static void unload(ClassLoader parentClassLoader) {
        classLoaders.remove(parentClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static <T extends Tree, Adapted> Adapted adapt(TreeVisitor<T, ?> delegate, Class<Adapted> adaptTo, TreeVisitor<? extends T, ?> ... mixins) {
        TreeVisitorAdapterClassLoader cl;
        Timer.Sample timer = Timer.start();
        String adaptedName = delegate.getClass().getName().trim().replace('$', '_') + "_" + adaptTo.getSimpleName();
        Class<? extends TreeVisitor> delegateType = TreeVisitorAdapter.adapterDelegateType(delegate);
        Object object = classLoaders;
        synchronized (object) {
            cl = classLoaders.computeIfAbsent(delegate.getClass().getClassLoader(), TreeVisitorAdapterClassLoader::new);
        }
        if (!cl.hasClass(adaptedName)) {
            object = classCreationLock;
            synchronized (object) {
                if (!cl.hasClass(adaptedName)) {
                    try (ClassCreator creator = ClassCreator.builder().classOutput((ClassOutput)cl).className(adaptedName).superClass(adaptTo).build();){
                        FieldCreator delegateField = creator.getFieldCreator("delegate", delegateType);
                        delegateField.setModifiers(2);
                        MethodCreator setDelegate = creator.getMethodCreator("setDelegate", Void.TYPE, new Class[]{delegateType});
                        setDelegate.setModifiers(1);
                        setDelegate.writeInstanceField(delegateField.getFieldDescriptor(), setDelegate.getThis(), setDelegate.getMethodParam(0));
                        setDelegate.invokeSpecialMethod(MethodDescriptor.ofMethod(adaptTo, (String)"setCursor", Void.TYPE, (Class[])new Class[]{Cursor.class}), setDelegate.getThis(), new ResultHandle[]{setDelegate.invokeVirtualMethod(MethodDescriptor.ofMethod(delegateType, (String)"getCursor", Cursor.class, (Class[])new Class[0]), setDelegate.getMethodParam(0), new ResultHandle[0])});
                        setDelegate.returnValue(null);
                        MethodCreator setCursor = creator.getMethodCreator("setCursor", Void.TYPE, new Class[]{Cursor.class});
                        setCursor.setModifiers(1);
                        setCursor.invokeSpecialMethod(MethodDescriptor.ofMethod(adaptTo, (String)"setCursor", Void.TYPE, (Class[])new Class[]{Cursor.class}), setCursor.getThis(), new ResultHandle[]{setCursor.getMethodParam(0)});
                        setCursor.invokeVirtualMethod(MethodDescriptor.ofMethod(delegateType, (String)"setCursor", Void.TYPE, (Class[])new Class[]{Cursor.class}), setCursor.readInstanceField(delegateField.getFieldDescriptor(), setCursor.getThis()), new ResultHandle[]{setCursor.getMethodParam(0)});
                        setCursor.returnValue(null);
                        for (Method method : delegate.getClass().getDeclaredMethods()) {
                            if (!method.getName().startsWith("visit") && !method.getName().equals("preVisit") && !method.getName().equals("postVisit")) continue;
                            block14: for (Method adaptToMethod : adaptTo.getMethods()) {
                                if (!method.getName().equals(adaptToMethod.getName()) || method.getParameterCount() != adaptToMethod.getParameterCount() || Modifier.isFinal(adaptToMethod.getModifiers())) continue;
                                Class<?>[] parameterTypes = method.getParameterTypes();
                                for (int i = 0; i < parameterTypes.length; ++i) {
                                    if (!method.getParameterTypes()[i].equals(parameterTypes[i])) continue block14;
                                }
                            }
                            MethodCreator visitMethod = creator.getMethodCreator(method.getName(), method.getReturnType(), (Object[])method.getParameterTypes());
                            visitMethod.setModifiers(method.getModifiers());
                            int paramLength = method.getParameters().length;
                            ResultHandle[] args = new ResultHandle[paramLength];
                            for (int i = 0; i < paramLength; ++i) {
                                args[i] = visitMethod.getMethodParam(i);
                            }
                            ResultHandle delegateCall = visitMethod.invokeVirtualMethod(MethodDescriptor.ofMethod(delegateType, (String)method.getName(), (Object)DescriptorUtils.classToStringRepresentation(method.getReturnType()), (Object[])method.getParameterTypes()), visitMethod.readInstanceField(delegateField.getFieldDescriptor(), visitMethod.getThis()), args);
                            visitMethod.returnValue(delegateCall);
                            ResultHandle ret = visitMethod.loadNull();
                            visitMethod.returnValue(ret);
                        }
                    }
                }
            }
        }
        try {
            Class<?> a = cl.loadClass(adaptedName);
            Object adapted = a.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            a.getDeclaredMethod("setDelegate", delegateType).invoke(adapted, delegate);
            return (Adapted)adapted;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            timer.stop(MetricsHelper.errorTags(Timer.builder((String)"rewrite.visitor.adapt").tag("adapt.to", adaptTo.getSimpleName()), e).register((MeterRegistry)Metrics.globalRegistry));
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends TreeVisitor> adapterDelegateType(TreeVisitor<?, ?> delegate) {
        for (TypeVariable<Class<?>> tp : delegate.getClass().getTypeParameters()) {
            Type[] typeArray = tp.getBounds();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type bound = typeArray[i];
                if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                return delegate.getClass();
            }
        }
        Class v2 = delegate.getClass();
        Type sup = v2.getGenericSuperclass();
        for (int i = 0; i < 20; ++i) {
            if (sup instanceof ParameterizedType) {
                for (Type bound : ((ParameterizedType)sup).getActualTypeArguments()) {
                    if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                    if (delegate.getLanguage() == null) {
                        return (Class)((ParameterizedType)sup).getRawType();
                    }
                    return v2;
                }
                sup = ((ParameterizedType)sup).getRawType();
                continue;
            }
            if (!(sup instanceof Class)) continue;
            v2 = (Class)sup;
            if (v2.getName().endsWith("IsoVisitor")) {
                return v2;
            }
            sup = ((Class)sup).getGenericSuperclass();
        }
        throw new IllegalArgumentException("Expected to find a tree type somewhere in the type parameters of the type hierarchy of visitor " + delegate.getClass().getName());
    }
}

