/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import java.time.LocalDate;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class DistinctCommitters
extends DataTable<Row> {
    public DistinctCommitters(Recipe recipe) {
        super(recipe, "Repository committers", "The distinct set of committers per repository.");
    }

    public static final class Row {
        @Column(displayName="Name", description="The name of the committer.")
        private final String name;
        @Column(displayName="Email", description="The email of the committer.")
        private final String email;
        @Column(displayName="Last commit", description="The date of this committer's last commit.")
        private final LocalDate lastCommit;
        @Column(displayName="Number of commits", description="The number of commits made by this committer.")
        private final int commits;

        @Generated
        public Row(String name, String email, LocalDate lastCommit, int commits) {
            this.name = name;
            this.email = email;
            this.lastCommit = lastCommit;
            this.commits = commits;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public LocalDate getLastCommit() {
            return this.lastCommit;
        }

        @Generated
        public int getCommits() {
            return this.commits;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCommits() != other.getCommits()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            LocalDate this$lastCommit = this.getLastCommit();
            LocalDate other$lastCommit = other.getLastCommit();
            return !(this$lastCommit == null ? other$lastCommit != null : !((Object)this$lastCommit).equals(other$lastCommit));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCommits();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            LocalDate $lastCommit = this.getLastCommit();
            result = result * 59 + ($lastCommit == null ? 43 : ((Object)$lastCommit).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DistinctCommitters.Row(name=" + this.getName() + ", email=" + this.getEmail() + ", lastCommit=" + this.getLastCommit() + ", commits=" + this.getCommits() + ")";
        }
    }
}

