/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Incubating;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.style.Style;

public interface SourceFile
extends Tree {
    default public boolean printEqualsInput(Parser.Input input, ExecutionContext ctx) {
        String printed = this.printAll();
        Charset charset = this.getCharset();
        if (charset != null) {
            return printed.equals(StringUtils.readFully(input.getSource(ctx), charset));
        }
        return printed.equals(StringUtils.readFully(input.getSource(ctx)));
    }

    public Path getSourcePath();

    public <T extends SourceFile> T withSourcePath(Path var1);

    public @Nullable Charset getCharset();

    public <T extends SourceFile> T withCharset(Charset var1);

    public boolean isCharsetBomMarked();

    public <T extends SourceFile> T withCharsetBomMarked(boolean var1);

    public @Nullable Checksum getChecksum();

    public <T extends SourceFile> T withChecksum(@Nullable Checksum var1);

    public @Nullable FileAttributes getFileAttributes();

    public <T extends SourceFile> T withFileAttributes(@Nullable FileAttributes var1);

    @Deprecated
    default public <S extends Style> @Nullable S getStyle(Class<S> styleClass) {
        return Style.from(styleClass, this);
    }

    @Deprecated
    default public <S extends Style> S getStyle(Class<S> styleClass, S defaultStyle) {
        return (S)Style.from(styleClass, this, () -> defaultStyle);
    }

    default public <P> byte[] printAllAsBytes(P p) {
        return this.printAll(p).getBytes(this.getCharset() == null ? StandardCharsets.UTF_8 : this.getCharset());
    }

    default public byte[] printAllAsBytes() {
        return this.printAllAsBytes(0);
    }

    default public <P> String printAll(P p) {
        return this.printAll(new PrintOutputCapture<P>(p));
    }

    default public <P> String printAll(PrintOutputCapture<P> out) {
        return this.print(new Cursor(null, "root"), out);
    }

    default public String printAll() {
        return this.printAll(0);
    }

    default public <P> String printAllTrimmed(P p) {
        return this.printTrimmed(p, new Cursor(null, "root"));
    }

    default public String printAllTrimmed() {
        return this.printAllTrimmed(0);
    }

    @Override
    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        throw new UnsupportedOperationException("SourceFile implementations should override this method");
    }

    @Incubating(since="8.2.0")
    default public <S, T extends S> T service(Class<S> service) {
        throw new UnsupportedOperationException("Service " + service + " not supported");
    }

    default public long getWeight(Predicate<Object> uniqueIdentity) {
        final AtomicInteger n = new AtomicInteger();
        new TreeVisitor<Tree, AtomicInteger>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, AtomicInteger atomicInteger) {
                if (tree != null) {
                    n.incrementAndGet();
                }
                return super.visit(tree, atomicInteger);
            }
        }.visit((Tree)this, n);
        return n.get();
    }
}

