/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.internal;

import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;

public class FindTreesOfType
extends TreeVisitor<Tree, ExecutionContext> {
    private final String type;
    private transient @Nullable Class<?> treeClass;

    @Override
    public Tree preVisit(@NonNull Tree tree, ExecutionContext ctx) {
        this.stopAfterPreVisit();
        return this.getType().isAssignableFrom(tree.getClass()) ? SearchResult.found(tree) : tree;
    }

    private Class<?> getType() {
        if (this.treeClass == null) {
            try {
                this.treeClass = Class.forName(this.type);
                if (!Tree.class.isAssignableFrom(this.treeClass)) {
                    throw new IllegalArgumentException(this.type + " is not a SourceFile type");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.treeClass;
    }

    @Generated
    public FindTreesOfType(String type) {
        this.type = type;
    }
}

