/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class DependencyMatcher {
    private final @Nullable String groupPattern;
    private final @Nullable String artifactPattern;
    private final @Nullable VersionComparator versionComparator;

    public DependencyMatcher(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable VersionComparator versionComparator) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.versionComparator = versionComparator;
    }

    public static Validated<DependencyMatcher> build(String pattern) {
        Validated<VersionComparator> validatedVersion;
        String[] patternPieces = pattern.split(":");
        if (patternPieces.length < 2) {
            return Validated.invalid("pattern", pattern, "missing required components. Must specify at least groupId:artifactId");
        }
        if (patternPieces.length > 3) {
            return Validated.invalid("pattern", pattern, "not a valid pattern. Valid patterns take the form groupId:artifactId, groupId:artifactId:version, or groupId:artifactId:version/versionPattern");
        }
        if (patternPieces.length < 3) {
            return Validated.valid("pattern", new DependencyMatcher(patternPieces[0], patternPieces[1], null));
        }
        if (patternPieces[2].contains("/")) {
            String[] versionPieces = patternPieces[2].split("/");
            if (versionPieces.length != 2) {
                return Validated.invalid("pattern", pattern, "unable to parse version \"" + patternPieces[2] + "\"");
            }
            validatedVersion = Semver.validate(versionPieces[0], versionPieces[1]);
        } else {
            validatedVersion = Semver.validate(patternPieces[2], null);
        }
        if (validatedVersion.isInvalid()) {
            return Validated.invalid("pattern", null, "Unable to parse version");
        }
        return Validated.valid("pattern", new DependencyMatcher(patternPieces[0], patternPieces[1], validatedVersion.getValue()));
    }

    public boolean matches(@Nullable String groupId, @Nullable String artifactId, String version) {
        return StringUtils.matchesGlob(groupId, this.groupPattern) && StringUtils.matchesGlob(artifactId, this.artifactPattern) && (this.versionComparator == null || this.versionComparator.isValid(null, version));
    }

    public boolean matches(@Nullable String groupId, @Nullable String artifactId) {
        return StringUtils.matchesGlob(groupId, this.groupPattern) && StringUtils.matchesGlob(artifactId, this.artifactPattern);
    }

    public boolean isValidVersion(@Nullable String currentVersion, String newVersion) {
        return this.versionComparator == null || this.versionComparator.isValid(currentVersion, newVersion);
    }

    public Optional<String> upgrade(String currentVersion, Collection<String> availableVersions) {
        if (this.versionComparator == null) {
            return Optional.empty();
        }
        return this.versionComparator.upgrade(currentVersion, availableVersions);
    }

    @NonNull
    @Generated
    public DependencyMatcher withGroupPattern(@Nullable String groupPattern) {
        return this.groupPattern == groupPattern ? this : new DependencyMatcher(groupPattern, this.artifactPattern, this.versionComparator);
    }

    @NonNull
    @Generated
    public DependencyMatcher withArtifactPattern(@Nullable String artifactPattern) {
        return this.artifactPattern == artifactPattern ? this : new DependencyMatcher(this.groupPattern, artifactPattern, this.versionComparator);
    }

    @NonNull
    @Generated
    public DependencyMatcher withVersionComparator(@Nullable VersionComparator versionComparator) {
        return this.versionComparator == versionComparator ? this : new DependencyMatcher(this.groupPattern, this.artifactPattern, versionComparator);
    }

    @Generated
    public @Nullable String getGroupPattern() {
        return this.groupPattern;
    }

    @Generated
    public @Nullable String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Generated
    public @Nullable VersionComparator getVersionComparator() {
        return this.versionComparator;
    }
}

