/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.Style;

public class NamedStyles
implements Marker {
    UUID id;
    String name;
    @NlsRewrite.DisplayName String displayName;
    @Nullable @NlsRewrite.Description String description;
    Set<String> tags;
    Collection<Style> styles;

    public static <S extends Style> @Nullable S merge(Class<S> styleClass, Iterable<? extends NamedStyles> namedStyles) {
        Style merged = null;
        for (NamedStyles namedStyles2 : namedStyles) {
            Collection<Style> styles = namedStyles2.styles;
            if (styles == null) continue;
            for (Style style : styles) {
                if (!styleClass.isInstance(style)) continue;
                style = style.applyDefaults();
                if (merged == null) {
                    merged = style;
                    continue;
                }
                merged = merged.merge(style);
            }
        }
        return (S)merged;
    }

    public static @Nullable NamedStyles merge(List<NamedStyles> styles) {
        if (styles.isEmpty()) {
            return null;
        }
        if (styles.size() == 1) {
            return styles.get(0);
        }
        HashSet styleClasses = new HashSet();
        for (NamedStyles namedStyles : styles) {
            for (Style style : namedStyles.getStyles()) {
                styleClasses.add(style.getClass());
            }
        }
        ArrayList<Style> mergedStyles = new ArrayList<Style>(styleClasses.size());
        for (Class clazz : styleClasses) {
            mergedStyles.add((Style)NamedStyles.merge(clazz, styles));
        }
        return new NamedStyles(Tree.randomId(), "MergedStyles", "Merged styles", "Merged Styles from " + styles.stream().map(NamedStyles::getName).collect(Collectors.joining(", ")), styles.stream().map(NamedStyles::getTags).flatMap(Collection::stream).collect(Collectors.toSet()), mergedStyles);
    }

    public Validated<Object> validate() {
        return Validated.none();
    }

    public <S extends Style> S getStyle(Class<S> styleClass) {
        S ret = NamedStyles.merge(styleClass, Collections.singletonList(this));
        assert (ret != null);
        return ret;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Collection<Style> getStyles() {
        return this.styles;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setStyles(Collection<Style> styles) {
        this.styles = styles;
    }

    @NonNull
    @Generated
    public String toString() {
        return "NamedStyles(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", styles=" + this.getStyles() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedStyles)) {
            return false;
        }
        NamedStyles other = (NamedStyles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof NamedStyles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public NamedStyles(UUID id, String name, String displayName, @Nullable String description, Set<String> tags, Collection<Style> styles) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.styles = styles;
    }

    @NonNull
    @Generated
    public NamedStyles withId(UUID id) {
        return this.id == id ? this : new NamedStyles(id, this.name, this.displayName, this.description, this.tags, this.styles);
    }

    @NonNull
    @Generated
    public NamedStyles withName(String name) {
        return this.name == name ? this : new NamedStyles(this.id, name, this.displayName, this.description, this.tags, this.styles);
    }

    @NonNull
    @Generated
    public NamedStyles withDisplayName(String displayName) {
        return this.displayName == displayName ? this : new NamedStyles(this.id, this.name, displayName, this.description, this.tags, this.styles);
    }

    @NonNull
    @Generated
    public NamedStyles withDescription(@Nullable String description) {
        return this.description == description ? this : new NamedStyles(this.id, this.name, this.displayName, description, this.tags, this.styles);
    }

    @NonNull
    @Generated
    public NamedStyles withTags(Set<String> tags) {
        return this.tags == tags ? this : new NamedStyles(this.id, this.name, this.displayName, this.description, tags, this.styles);
    }

    @NonNull
    @Generated
    public NamedStyles withStyles(Collection<Style> styles) {
        return this.styles == styles ? this : new NamedStyles(this.id, this.name, this.displayName, this.description, this.tags, styles);
    }
}

